/*
 * Decompiled with CFR 0.152.
 */
package i18nupdatemod.modlauncher;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import i18nupdatemod.I18nUpdateMod;
import i18nupdatemod.util.Log;
import i18nupdatemod.util.Reflection;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModLauncherService
implements ITransformationService {
    @NotNull
    public String name() {
        return "I18nUpdateMod";
    }

    public void initialize(IEnvironment environment) {
        Optional minecraftPath = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get());
        if (!minecraftPath.isPresent()) {
            Log.warning("Minecraft path not found");
            return;
        }
        Log.setMinecraftLogFile((Path)minecraftPath.get());
        String minecraftVersion = this.getMinecraftVersion();
        if (minecraftVersion == null) {
            Log.warning("Minecraft version not found");
            return;
        }
        I18nUpdateMod.init((Path)minecraftPath.get(), minecraftVersion, "Forge");
    }

    public void beginScanning(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) throws IncompatibleEnvironmentException {
    }

    @NotNull
    public List<ITransformer> transformers() {
        return Collections.emptyList();
    }

    private String getMinecraftVersion() {
        try {
            String[] args = (String[])Reflection.clazz(Launcher.INSTANCE).get("argumentHandler").get("args").get();
            for (int i = 0; i < args.length - 1; ++i) {
                if (!args[i].equalsIgnoreCase("--fml.mcversion")) continue;
                return args[i + 1];
            }
        }
        catch (Exception e) {
            Log.warning(String.format("Error getting minecraft version: %s", e));
        }
        return null;
    }
}

