/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.gui.ControllerAxis;
import com.mrcrayfish.controllable.client.gui.ControllerButton;
import com.mrcrayfish.controllable.client.gui.screens.ThumbstickSettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import com.mrcrayfish.controllable.client.input.ButtonStates;
import com.mrcrayfish.controllable.client.input.Buttons;
import com.mrcrayfish.controllable.client.input.Controller;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;

public class ControllerLayoutScreen
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("controllable", "textures/gui/controller.png");
    private final List<ControllerButton> controllerButtons = new ArrayList<ControllerButton>();
    private int configureButton = -1;
    private boolean validLayout;
    private final Screen parentScreen;
    private final LayoutButtonStates states = new LayoutButtonStates();
    private Button doneButton;
    private Button resetButton;
    private Button thumbstickButton;

    protected ControllerLayoutScreen(Screen parentScreen) {
        super((Component)Component.m_237115_((String)"controllable.gui.title.layout"));
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        this.controllerButtons.clear();
        this.controllerButtons.add(new ControllerButton(this, 0, 29, 9, 7, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 1, 32, 6, 13, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 2, 26, 6, 16, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 3, 29, 3, 10, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 9, 5, -2, 25, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 10, 26, -2, 32, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 11, -10, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 12, 41, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 14, 6, 9, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 16, 9, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 15, 3, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 13, 6, 3, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 4, 14, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 6, 21, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 5, 17, 8, 46, 0, 4, 4, 5));
        this.controllerButtons.add(new ControllerAxis(this, 7, 9, 12, 0, 0, 7, 7, 5));
        this.controllerButtons.add(new ControllerAxis(this, 8, 22, 12, 0, 0, 7, 7, 5));
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"controllable.gui.save"), button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parentScreen)).m_252794_(this.f_96543_ / 2 - 154, this.f_96544_ - 32).m_253046_(100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parentScreen)).m_252794_(this.f_96543_ / 2 + 54, this.f_96544_ - 32).m_253046_(100, 20).m_253136_());
        int width = 190;
        int x = this.f_96543_ / 2 - width / 2;
        int y = this.f_96544_ / 2 - 50 - 35;
        this.thumbstickButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(x + width / 2 - 10, y + 90, 20, TEXTURE, 92, 0, 16, 16, button -> Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new ThumbstickSettingsScreen(this))));
    }

    public void m_86600_() {
        this.doneButton.m_93666_((Component)Component.m_237115_((String)"controllable.gui.save").m_130940_(this.validLayout ? ChatFormatting.WHITE : ChatFormatting.RED));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ArrayList<Object> components;
        this.m_280039_(graphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int width = 190;
        int height = 120;
        int x = this.f_96543_ / 2 - width / 2;
        int y = this.f_96544_ / 2 - 50 - 35;
        graphics.m_280411_(TEXTURE, x, y, width, height, 50.0f, 0.0f, 38, 24, 256, 256);
        this.controllerButtons.forEach(controllerButton -> controllerButton.draw(graphics, x, y, mouseX, mouseY, this.configureButton == controllerButton.getButton()));
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        this.drawMultiLineCenteredString(graphics, this.f_96547_, (Component)Component.m_237115_((String)"controllable.gui.layout.info").m_130940_(ChatFormatting.GRAY), x + width / 2, y + 135, width + 190, -1);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.configureButton != -1) {
            RenderSystem.disableDepthTest();
            graphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"controllable.gui.layout.press_button"), this.f_96543_ / 2, this.f_96544_ / 2, -1);
            RenderSystem.enableDepthTest();
            return;
        }
        ControllerButton button = this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null);
        if (button != null) {
            components = new ArrayList<Object>();
            components.add(Component.m_237110_((String)"controllable.gui.layout.button", (Object[])new Object[]{Component.m_237115_((String)Buttons.NAMES[button.getButton()]).m_130940_(ChatFormatting.BLUE)}));
            components.add(Component.m_237115_((String)"controllable.gui.layout.remap").m_130940_(ChatFormatting.GRAY));
            graphics.m_280666_(this.f_96547_, components, mouseX, mouseY);
        }
        if (!this.validLayout && this.doneButton.m_198029_()) {
            components = new ArrayList();
            components.add(Component.m_237115_((String)"controllable.gui.layout.warning").m_130940_(ChatFormatting.RED).m_7532_());
            components.addAll(this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"controllable.gui.layout.invalid_layout").m_130940_(ChatFormatting.GRAY), 180));
            graphics.m_280245_(this.f_96547_, components, mouseX, mouseY - 50);
        }
        if (this.thumbstickButton.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"controllable.gui.layout.thumbsticks"), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        ControllerButton button;
        if (mouseButton == 0 && this.configureButton == -1 && (button = (ControllerButton)this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null)) != null) {
            this.configureButton = button.getButton();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7933_(int key, int scanCode, int mods) {
        if (key == 256 && this.configureButton != -1) {
            this.configureButton = -1;
            return true;
        }
        return super.m_7933_(key, scanCode, mods);
    }

    public void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (state) {
            if (!this.states.getState(index)) {
                this.states.setState(index, true);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12632_, (float)1.0f));
            }
        } else if (this.states.getState(index)) {
            this.states.setState(index, false);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12632_, (float)0.9f));
        }
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    private void drawMultiLineCenteredString(GuiGraphics graphics, Font font, Component component, int x, int y, int width, int color) {
        for (FormattedCharSequence s : font.m_92923_((FormattedText)component, width)) {
            graphics.m_280364_(font, s, x - font.m_92724_(s) / 2, y, color);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public static class LayoutButtonStates
    extends ButtonStates {
        @Override
        public void setState(int index, boolean state) {
            super.setState(index, state);
        }
    }
}

