/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.mixin.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.platform.ClientServices;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={AbstractContainerScreen.class})
public abstract class ContainerScreenMixin {
    @Shadow
    private ItemStack f_97724_;

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;slotClicked(Lnet/minecraft/world/inventory/Slot;IILnet/minecraft/world/inventory/ClickType;)V", ordinal=1))
    private void controllableOnClicked(AbstractContainerScreen<?> screen, Slot slot, int slotId, int button, ClickType type) {
        if (slotId != -999 && ContainerScreenMixin.canQuickMove()) {
            this.f_97724_ = slot != null && slot.m_6657_() ? slot.m_7993_().m_41777_() : ItemStack.f_41583_;
            type = ClickType.QUICK_MOVE;
        }
        ClientServices.CLIENT.clickSlot(screen, slot, slotId, button, type);
    }

    @Redirect(method={"mouseReleased"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;slotClicked(Lnet/minecraft/world/inventory/Slot;IILnet/minecraft/world/inventory/ClickType;)V", ordinal=9))
    private void controllableOnReleased(AbstractContainerScreen<?> screen, Slot slot, int slotId, int button, ClickType type) {
        if (slotId != -999 && ContainerScreenMixin.canQuickMove()) {
            this.f_97724_ = slot != null && slot.m_6657_() ? slot.m_7993_().m_41777_() : ItemStack.f_41583_;
            type = ClickType.QUICK_MOVE;
        }
        ClientServices.CLIENT.clickSlot(screen, slot, slotId, button, type);
    }

    private static boolean canQuickMove() {
        Controller controller = Controllable.getController();
        return controller != null && ButtonBindings.QUICK_MOVE.isButtonPressed();
    }
}

