/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public class NBTHelper {
    public static Vec3 getVector3d(CompoundTag tag, String key) {
        ListTag listnbt = tag.m_128437_(key, 6);
        return new Vec3(listnbt.m_128772_(0), listnbt.m_128772_(1), listnbt.m_128772_(2));
    }

    public static void putVector3d(CompoundTag tag, String key, Vec3 value) {
        tag.m_128365_(key, (Tag)NBTHelper.newDoubleNBTList(value.f_82479_, value.f_82480_, value.f_82481_));
    }

    public static ListTag newDoubleNBTList(Vec3 value) {
        return NBTHelper.newDoubleNBTList(value.f_82479_, value.f_82480_, value.f_82481_);
    }

    public static ListTag newDoubleNBTList(double ... numbers) {
        ListTag listnbt = new ListTag();
        for (double dValue : numbers) {
            listnbt.add((Object)DoubleTag.m_128500_((double)dValue));
        }
        return listnbt;
    }

    public static NBTCoupler getNBTCoupler(CompoundTag tag) {
        return new NBTCoupler(tag);
    }

    public static <T> void writeNBT(CompoundTag dest, String key, T ... value) {
        if (value == null || value.length != 1 || value[0] == null) {
            return;
        }
        Class<?> type = value.getClass().getComponentType();
        if (type.equals(Integer.class)) {
            dest.m_128405_(key, ((Integer)value[0]).intValue());
        } else if (type.equals(Float.class)) {
            dest.m_128350_(key, ((Float)value[0]).floatValue());
        } else if (type.equals(Short.class)) {
            dest.m_128376_(key, ((Short)value[0]).shortValue());
        } else if (type.equals(Byte.class)) {
            dest.m_128344_(key, ((Byte)value[0]).byteValue());
        } else if (type.equals(Long.class)) {
            dest.m_128356_(key, ((Long)value[0]).longValue());
        } else if (type.equals(Double.class)) {
            dest.m_128347_(key, ((Double)value[0]).doubleValue());
        } else if (type.equals(Boolean.class)) {
            dest.m_128379_(key, ((Boolean)value[0]).booleanValue());
        } else if (value[0] != null) {
            if (type.equals(UUID.class)) {
                dest.m_128362_(key, (UUID)value[0]);
            } else if (type.equals(byte[].class)) {
                dest.m_128382_(key, (byte[])value[0]);
            } else if (type.equals(int[].class)) {
                dest.m_128385_(key, (int[])value[0]);
            } else if (type.equals(long[].class)) {
                dest.m_128388_(key, (long[])value[0]);
            } else if (type.equals(CompoundTag.class)) {
                dest.m_128365_(key, (Tag)((CompoundTag)value[0]));
            } else if (type.equals(String.class)) {
                dest.m_128359_(key, (String)value[0]);
            } else if (type.equals(Vec3.class)) {
                NBTHelper.putVector3d(dest, key, (Vec3)value[0]);
            }
        }
    }

    public static <T> void readNBT(CompoundTag src, String key, Consumer<T> dest, T ... values) {
        NBTHelper.readNBT(src, key, dest, false, values);
    }

    public static <T> void readNBT(CompoundTag src, String key, Consumer<T> dest, boolean isNullable, T ... defaultValue) {
        if (isNullable) {
            dest.accept(NBTHelper.castValue(key, src, defaultValue).orElse(null));
        } else {
            NBTHelper.castValue(key, src, defaultValue).ifPresent(dest);
        }
    }

    public static <T> Optional<T> castValue(String key, CompoundTag src, T ... defaultValue) {
        if (defaultValue == null) {
            return Optional.empty();
        }
        Class<?> type = defaultValue.getClass().getComponentType();
        Object result = null;
        int typeId = -1;
        if (type.equals(Integer.class)) {
            typeId = 99;
            result = src.m_128451_(key);
        } else if (type.equals(Float.class)) {
            typeId = 99;
            result = Float.valueOf(src.m_128457_(key));
        } else if (type.equals(Short.class)) {
            typeId = 99;
            result = src.m_128448_(key);
        } else if (type.equals(Byte.class)) {
            typeId = 99;
            result = src.m_128445_(key);
        } else if (type.equals(Long.class)) {
            typeId = 99;
            result = src.m_128454_(key);
        } else if (type.equals(Double.class)) {
            typeId = 99;
            result = src.m_128459_(key);
        } else if (type.equals(Boolean.class)) {
            typeId = 99;
            result = src.m_128471_(key);
        } else if (src.m_128441_(key)) {
            if (type.equals(UUID.class)) {
                typeId = -2;
                if (src.m_128403_(key)) {
                    result = src.m_128342_(key);
                }
            } else if (type.equals(byte[].class)) {
                typeId = 7;
                result = src.m_128463_(key);
            } else if (type.equals(int[].class)) {
                typeId = 11;
                result = src.m_128465_(key);
            } else if (type.equals(long[].class)) {
                typeId = 12;
                result = src.m_128467_(key);
            } else if (type.equals(CompoundTag.class)) {
                typeId = 10;
                result = src.m_128469_(key);
            } else if (type.equals(String.class)) {
                typeId = 8;
                result = src.m_128461_(key);
            }
        } else if (type.equals(Vec3.class)) {
            typeId = 6;
            result = NBTHelper.getVector3d(src, key);
        }
        if (0 < defaultValue.length) {
            boolean exists;
            boolean bl = exists = typeId == -2 ? src.m_128403_(key) : src.m_128425_(key, typeId);
            if (!exists) {
                result = defaultValue;
            }
        }
        return Optional.ofNullable(result);
    }

    public static class NBTCoupler {
        CompoundTag instance;
        NBTCoupler parent = null;

        protected NBTCoupler(CompoundTag tag) {
            this.instance = tag;
        }

        public <T> NBTCoupler put(String key, T ... value) {
            NBTHelper.writeNBT(this.instance, key, value);
            return this;
        }

        public <T> NBTCoupler get(String key, Consumer<T> dest, T ... values) {
            return this.get(key, dest, false, values);
        }

        public <T> NBTCoupler get(String key, Consumer<T> dest, boolean isNullable, T ... values) {
            NBTHelper.readNBT(this.instance, key, dest, isNullable, values);
            return this;
        }

        public NBTCoupler remove(String key) {
            if (this.instance.m_128403_(key)) {
                this.instance.m_128473_(key + "Most");
                this.instance.m_128473_(key + "Least");
            } else {
                this.instance.m_128473_(key);
            }
            return this;
        }

        public NBTCoupler getChild(String key) {
            CompoundTag tag;
            if (this.instance.m_128425_(key, 10)) {
                tag = this.instance.m_128469_(key);
            } else {
                tag = new CompoundTag();
                this.instance.m_128365_(key, (Tag)tag);
            }
            return NBTHelper.getNBTCoupler(tag);
        }

        public NBTCoupler getParent() {
            if (this.parent != null) {
                return this.parent;
            }
            return this;
        }

        public CompoundTag getRawCompound() {
            return this.instance;
        }

        public CompoundTag getRawCompound(String key) {
            if (this.instance.m_128425_(key, 10)) {
                return this.instance.m_128469_(key);
            }
            CompoundTag nbt = new CompoundTag();
            this.instance.m_128365_(key, (Tag)nbt);
            return nbt;
        }

        public NBTCoupler doRawCompound(String key, Consumer<CompoundTag> action) {
            if (this.instance.m_128425_(key, 10)) {
                action.accept(this.instance.m_128469_(key));
            }
            return this;
        }
    }
}

