/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class GemRegistry
extends WeightedDynamicRegistry<Gem> {
    public static final GemRegistry INSTANCE = new GemRegistry();

    public GemRegistry() {
        super(AdventureModule.LOGGER, "gems", true, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("gem"), Gem.CODEC);
    }

    @SafeVarargs
    public static ItemStack createRandomGemStack(RandomSource rand, ServerLevel level, float luck, Predicate<Gem> ... filter) {
        Gem gem = (Gem)INSTANCE.getRandomItem(rand, luck, filter);
        if (gem == null) {
            return ItemStack.f_41583_;
        }
        RarityClamp clamp = AdventureConfig.GEM_DIM_RARITIES.get(level.m_46472_().m_135782_());
        LootRarity rarity = gem.clamp(LootRarity.random(rand, luck, clamp));
        return GemRegistry.createGemStack(gem, rarity);
    }

    public static ItemStack createGemStack(Gem gem, LootRarity rarity) {
        ItemStack stack = new ItemStack((ItemLike)Adventure.Items.GEM.get());
        GemItem.setGem(stack, gem);
        AffixHelper.setRarity(stack, rarity);
        return stack;
    }

    public final ICondition.IContext _getContext() {
        return this.getContext();
    }
}

