/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.cutting;

import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingScreen;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.cutting.GemCuttingMenu;
import dev.shadowsoffire.apotheosis.adventure.client.GrayBufferSource;
import dev.shadowsoffire.apotheosis.adventure.client.SimpleTexButton;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.util.DrawsOnLeft;
import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.screen.PlaceboContainerScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GemCuttingScreen
extends PlaceboContainerScreen<GemCuttingMenu>
implements DrawsOnLeft {
    public static final ResourceLocation TEXTURE = new ResourceLocation("apotheosis", "textures/gui/gem_cutting.png");
    protected final ItemStack displayDust = ((Item)Adventure.Items.GEM_DUST.get()).m_7968_();
    protected ItemStack displayMat;
    protected SimpleTexButton upgradeBtn;

    public GemCuttingScreen(GemCuttingMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        ((GemCuttingMenu)this.f_97732_).addSlotListener((id, stack) -> this.updateBtnStatus());
        this.f_97727_ = 180;
        this.f_97729_ = 5;
        this.f_97731_ = 86;
    }

    protected void m_7856_() {
        super.m_7856_();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.upgradeBtn = (SimpleTexButton)this.m_142416_((GuiEventListener)new SimpleTexButton(left + 125, top + 30, 40, 40, 216, 0, TEXTURE, 256, 256, this::clickUpgradeBtn, (Component)Component.m_237115_((String)"button.apotheosis.upgrade")).setInactiveMessage((Component)Component.m_237115_((String)"button.apotheosis.upgrade.no").m_130940_(ChatFormatting.RED)));
        this.updateBtnStatus();
    }

    protected void clickUpgradeBtn(Button btn) {
        this.f_96541_.f_91072_.m_105208_(((GemCuttingMenu)this.f_97732_).f_38840_, 0);
        GemUpgradeSound.start(((GemCuttingMenu)this.f_97732_).player.m_20183_());
    }

    protected void updateBtnStatus() {
        ItemStack gem = ((GemCuttingMenu)this.f_97732_).m_38853_(0).m_7993_();
        ItemStack left = ((GemCuttingMenu)this.f_97732_).m_38853_(1).m_7993_();
        ItemStack bot = ((GemCuttingMenu)this.f_97732_).m_38853_(2).m_7993_();
        ItemStack right = ((GemCuttingMenu)this.f_97732_).m_38853_(3).m_7993_();
        for (GemCuttingMenu.GemCuttingRecipe r : GemCuttingMenu.RECIPES) {
            if (!r.matches(gem, left, bot, right)) continue;
            this.upgradeBtn.f_93623_ = true;
            return;
        }
        ItemStack itemStack = this.displayMat = gem.m_41619_() ? ItemStack.f_41583_ : new ItemStack((ItemLike)((LootRarity)AffixHelper.getRarity(gem).get()).getMaterial());
        if (this.upgradeBtn != null) {
            this.upgradeBtn.f_93623_ = false;
        }
    }

    protected void m_7286_(GuiGraphics gfx, float pPartialTick, int pMouseX, int pMouseY) {
        int xCenter = (this.f_96543_ - this.f_97726_) / 2;
        int yCenter = (this.f_96544_ - this.f_97727_) / 2;
        gfx.m_280218_(TEXTURE, xCenter, yCenter, 0, 0, this.f_97726_, this.f_97727_);
        if (this.hasItem(0) && AffixHelper.getRarity(((GemCuttingMenu)this.f_97732_).m_38853_(0).m_7993_()) != RarityRegistry.getMaxRarity()) {
            if (!this.hasItem(1)) {
                this.renderItem(gfx, this.displayDust, ((GemCuttingMenu)this.f_97732_).m_38853_(1));
            }
            if (!this.hasItem(2)) {
                this.renderItem(gfx, ((GemCuttingMenu)this.f_97732_).m_38853_(0).m_7993_(), ((GemCuttingMenu)this.f_97732_).m_38853_(2));
            }
            if (!this.hasItem(3)) {
                this.renderItem(gfx, this.displayMat, ((GemCuttingMenu)this.f_97732_).m_38853_(3));
            }
        }
    }

    protected boolean hasItem(int slot) {
        return ((GemCuttingMenu)this.f_97732_).m_38853_(slot).m_6657_();
    }

    protected void renderItem(GuiGraphics gfx, ItemStack stack, Slot slot) {
        SalvagingScreen.renderGuiItem(gfx, stack, this.getGuiLeft() + slot.f_40220_, this.getGuiTop() + slot.f_40221_, GrayBufferSource::new);
    }

    protected void m_280072_(GuiGraphics gfx, int pX, int pY) {
        ItemStack gemStack = ((GemCuttingMenu)this.f_97732_).m_38853_(0).m_7993_();
        GemInstance gem = GemInstance.unsocketed(gemStack);
        GemInstance secondary = GemInstance.unsocketed(((GemCuttingMenu)this.f_97732_).m_38853_(2).m_7993_());
        ArrayList<Component> list = new ArrayList<Component>();
        if (gem.isValidUnsocketed()) {
            int dust = ((GemCuttingMenu)this.f_97732_).m_38853_(1).m_7993_().m_41613_();
            DynamicHolder<LootRarity> rarity = gem.rarity();
            if (rarity == RarityRegistry.getMaxRarity()) {
                list.add((Component)Component.m_237115_((String)"text.apotheosis.no_upgrade").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE}));
            } else {
                list.add((Component)Component.m_237115_((String)"text.apotheosis.cut_cost").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE}));
                list.add(CommonComponents.f_237098_);
                int dustCost = GemCuttingMenu.getDustCost((LootRarity)rarity.get());
                boolean hasDust = dust > dustCost;
                list.add((Component)Component.m_237110_((String)"text.apotheosis.cost", (Object[])new Object[]{dustCost, ((Item)Adventure.Items.GEM_DUST.get()).m_7626_(ItemStack.f_41583_)}).m_130940_(hasDust ? ChatFormatting.GREEN : ChatFormatting.RED));
                boolean hasGem2 = secondary.isValidUnsocketed() && gem.gem() == secondary.gem() && rarity == secondary.rarity();
                list.add((Component)Component.m_237110_((String)"text.apotheosis.cost", (Object[])new Object[]{1, gemStack.m_41786_().getString()}).m_130940_(hasGem2 ? ChatFormatting.GREEN : ChatFormatting.RED));
                list.add((Component)Component.m_237115_((String)"text.apotheosis.one_rarity_mat").m_130940_(ChatFormatting.GRAY));
                this.addMatTooltip(RarityRegistry.next(rarity), 1, list);
                this.addMatTooltip(rarity, 3, list);
                if (rarity != RarityRegistry.getMinRarity()) {
                    this.addMatTooltip(RarityRegistry.prev(rarity), 9, list);
                }
            }
        }
        this.drawOnLeft(gfx, list, this.getGuiTop() + 16);
        super.m_280072_(gfx, pX, pY);
    }

    private void addMatTooltip(DynamicHolder<LootRarity> rarity, int cost, List<Component> list) {
        Item rarityMat = ((LootRarity)rarity.get()).getMaterial();
        ItemStack slotMat = ((GemCuttingMenu)this.f_97732_).m_38853_(3).m_7993_();
        boolean hasMats = slotMat.m_41720_() == rarityMat && slotMat.m_41613_() >= cost;
        list.add((Component)AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"text.apotheosis.cost", (Object[])new Object[]{cost, rarityMat.m_7626_(ItemStack.f_41583_)}).m_130940_(!hasMats ? ChatFormatting.RED : ChatFormatting.YELLOW)));
    }

    protected static class GemUpgradeSound
    extends AbstractTickableSoundInstance {
        protected int ticks = 0;
        protected float pitchOff;

        public GemUpgradeSound(BlockPos pos) {
            super(SoundEvents.f_144242_, SoundSource.BLOCKS, Minecraft.m_91087_().f_91073_.f_46441_);
            this.f_119575_ = (float)pos.m_123341_() + 0.5f;
            this.f_119576_ = pos.m_123342_();
            this.f_119577_ = (float)pos.m_123343_() + 0.5f;
            this.f_119573_ = 1.5f;
            this.f_119574_ = 1.5f + 0.35f * (1.0f - 2.0f * this.f_235066_.m_188501_());
            this.pitchOff = 0.35f * (1.0f - 2.0f * this.f_235066_.m_188501_());
            this.f_119579_ = 999;
        }

        public void m_7788_() {
            if (this.ticks == 4 || this.ticks == 9) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_144242_, (float)(this.f_119574_ + this.pitchOff), (float)1.5f));
                this.pitchOff = -this.pitchOff;
            }
            if (this.ticks++ > 8) {
                this.m_119609_();
            }
        }

        public static void start(BlockPos pos) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new GemUpgradeSound(pos));
        }
    }
}

