/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.compat;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.boss.ApothBoss;
import dev.shadowsoffire.apotheosis.adventure.boss.BossRegistry;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class GatewaysCompat {
    public static void register() {
        WaveEntity.CODEC.register(Apotheosis.loc("boss"), BossWaveEntity.CODEC);
        Reward.CODEC.register(Apotheosis.loc("affix"), RarityAffixItemReward.CODEC);
    }

    public static class BossWaveEntity
    implements WaveEntity {
        public static Codec<BossWaveEntity> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.nullableField((Codec)ResourceLocation.f_135803_, (String)"boss").forGetter(b -> b.bossId)).apply((Applicative)inst, BossWaveEntity::new));
        private final Optional<ResourceLocation> bossId;
        private final Supplier<ApothBoss> boss;

        public BossWaveEntity(Optional<ResourceLocation> bossId) {
            this.bossId = bossId;
            this.boss = Suppliers.memoize(() -> bossId.map(arg_0 -> ((BossRegistry)BossRegistry.INSTANCE).getValue(arg_0)).orElse(null));
        }

        public LivingEntity createEntity(Level level) {
            ApothBoss realBoss;
            ApothBoss apothBoss = realBoss = this.bossId.isEmpty() ? (ApothBoss)BossRegistry.INSTANCE.getRandomItem(level.f_46441_) : this.boss.get();
            if (realBoss == null) {
                return null;
            }
            return realBoss.createBoss((ServerLevelAccessor)level, BlockPos.f_121853_, level.f_46441_, 0.0f);
        }

        public MutableComponent getDescription() {
            return Component.m_237110_((String)"misc.apotheosis.boss", (Object[])new Object[]{Component.m_237115_((String)(this.bossId.isEmpty() ? "misc.apotheosis.random" : this.boss.get().getEntity().m_20675_()))});
        }

        public boolean shouldFinalizeSpawn() {
            return false;
        }

        public Codec<? extends WaveEntity> getCodec() {
            return CODEC;
        }

        public int getCount() {
            return 1;
        }
    }

    public record RarityAffixItemReward(DynamicHolder<LootRarity> rarity) implements Reward
    {
        public static Codec<RarityAffixItemReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RarityRegistry.INSTANCE.holderCodec().fieldOf("rarity").forGetter(RarityAffixItemReward::rarity)).apply((Applicative)inst, RarityAffixItemReward::new));

        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            list.accept(LootController.createLootItem(((AffixLootEntry)AffixLootRegistry.INSTANCE.getRandomItem(level.f_46441_, summoner.m_36336_(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((Level)level), GameStagesCompat.IStaged.matches(summoner)})).getStack(), (LootRarity)this.rarity.get(), level.f_46441_));
        }

        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237110_((String)"reward.apotheosis.affix", (Object[])new Object[]{((LootRarity)this.rarity.get()).toComponent()}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }
}

