/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootController {
    static Random jRand = new Random();

    public static ItemStack createLootItem(ItemStack stack, LootRarity rarity, RandomSource rand) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            return stack;
        }
        return LootController.createLootItem(stack, cat, rarity, rand);
    }

    public static ItemStack createLootItem(ItemStack stack, LootCategory cat, LootRarity rarity, RandomSource rand) {
        HashSet<DynamicHolder<Affix>> selected = new HashSet<DynamicHolder<Affix>>();
        MutableInt sockets = new MutableInt(0);
        float durability = 0.0f;
        for (LootRarity.LootRule rule : rarity.getRules()) {
            if (rule.type() == AffixType.DURABILITY) {
                durability = rule.chance();
                continue;
            }
            rule.execute(stack, rarity, selected, sockets, rand);
        }
        HashMap<DynamicHolder<? extends Affix>, AffixInstance> loaded = new HashMap<DynamicHolder<? extends Affix>, AffixInstance>();
        ArrayList<AffixInstance> nameList = new ArrayList<AffixInstance>(selected.size());
        for (DynamicHolder dynamicHolder : selected) {
            AffixInstance inst = new AffixInstance((DynamicHolder<? extends Affix>)dynamicHolder, stack, (DynamicHolder<LootRarity>)RarityRegistry.INSTANCE.holder(rarity), rand.m_188501_());
            loaded.put(dynamicHolder, inst);
            nameList.add(inst);
        }
        if (nameList.size() == 0) {
            throw new RuntimeException(String.format("Failed to locate any affixes for %s{%s} with category %s and rarity %s.", stack.m_41720_(), stack.m_41783_(), cat, rarity));
        }
        if (sockets.intValue() > 0) {
            SocketHelper.setSockets(stack, sockets.intValue());
        }
        if (durability > 0.0f) {
            loaded.put(Apoth.Affixes.DURABLE, new AffixInstance(Apoth.Affixes.DURABLE, stack, (DynamicHolder<LootRarity>)RarityRegistry.INSTANCE.holder(rarity), durability + AffixHelper.step(-0.07f, 14, 0.01f).get(rand.m_188501_())));
        }
        jRand.setSeed(rand.m_188505_());
        Collections.shuffle(nameList, jRand);
        String key = nameList.size() > 1 ? "misc.apotheosis.affix_name.three" : "misc.apotheosis.affix_name.two";
        MutableComponent mutableComponent = Component.m_237110_((String)key, (Object[])new Object[]{((AffixInstance)nameList.get(0)).getName(true), "", nameList.size() > 1 ? ((AffixInstance)nameList.get(1)).getName(false) : ""}).m_130948_(Style.f_131099_.m_131148_(rarity.getColor()));
        AffixHelper.setRarity(stack, rarity);
        AffixHelper.setAffixes(stack, loaded);
        AffixHelper.setName(stack, (Component)mutableComponent);
        return stack;
    }

    public static ItemStack createRandomLootItem(RandomSource rand, @Nullable LootRarity rarity, Player player, ServerLevelAccessor level) {
        AffixLootEntry entry = (AffixLootEntry)AffixLootRegistry.INSTANCE.getRandomItem(rand, player.m_36336_(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((Level)level.m_6018_()), GameStagesCompat.IStaged.matches(player)});
        if (entry == null) {
            return ItemStack.f_41583_;
        }
        if (rarity == null) {
            rarity = LootRarity.random(rand, player.m_36336_(), entry);
        }
        return LootController.createLootItem(entry.getStack(), entry.getType(), rarity, rand);
    }
}

