/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench;

import com.google.common.collect.ImmutableSet;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.EnchModuleClient;
import dev.shadowsoffire.apotheosis.ench.EnchModuleEvents;
import dev.shadowsoffire.apotheosis.ench.EnchantmentInfo;
import dev.shadowsoffire.apotheosis.ench.anvil.AnvilTile;
import dev.shadowsoffire.apotheosis.ench.anvil.ApothAnvilBlock;
import dev.shadowsoffire.apotheosis.ench.anvil.ApothAnvilItem;
import dev.shadowsoffire.apotheosis.ench.asm.EnchHooks;
import dev.shadowsoffire.apotheosis.ench.compat.EnchTOPPlugin;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryContainer;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryTile;
import dev.shadowsoffire.apotheosis.ench.objects.TomeItem;
import dev.shadowsoffire.apotheosis.ench.objects.TypedShelfBlock;
import dev.shadowsoffire.apotheosis.ench.objects.WardenLootModifier;
import dev.shadowsoffire.apotheosis.ench.replacements.BaneEnchant;
import dev.shadowsoffire.apotheosis.ench.replacements.DefenseEnchant;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantBlock;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantTile;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingRecipe;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import dev.shadowsoffire.apotheosis.ench.table.KeepNBTEnchantingRecipe;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.loot.LootSystem;
import dev.shadowsoffire.placebo.menu.MenuUtil;
import dev.shadowsoffire.placebo.registry.RegistryEvent;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import dev.shadowsoffire.placebo.util.PlaceboUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnchModule {
    public static final Map<Enchantment, EnchantmentInfo> ENCHANTMENT_INFO = new HashMap<Enchantment, EnchantmentInfo>();
    public static final Object2IntMap<Enchantment> ENCH_HARD_CAPS = new Object2IntOpenHashMap();
    public static final String ENCH_HARD_CAP_IMC = "set_ench_hard_cap";
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Enchantment");
    public static final List<TomeItem> TYPED_BOOKS = new ArrayList<TomeItem>();
    public static final EquipmentSlot[] ARMOR = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final EnchantmentCategory HOE = EnchantmentCategory.create((String)"HOE", i -> i instanceof HoeItem);
    public static final EnchantmentCategory SHIELD = EnchantmentCategory.create((String)"SHIELD", i -> i instanceof ShieldItem);
    public static final EnchantmentCategory ANVIL = EnchantmentCategory.create((String)"ANVIL", i -> i instanceof BlockItem && ((BlockItem)i).m_40614_() instanceof AnvilBlock);
    public static final EnchantmentCategory SHEARS = EnchantmentCategory.create((String)"SHEARS", i -> i instanceof ShearsItem);
    public static final EnchantmentCategory PICKAXE = EnchantmentCategory.create((String)"PICKAXE", i -> i.canPerformAction(new ItemStack((ItemLike)i), ToolActions.PICKAXE_DIG));
    public static final EnchantmentCategory AXE = EnchantmentCategory.create((String)"AXE", i -> i.canPerformAction(new ItemStack((ItemLike)i), ToolActions.AXE_DIG));
    public static final EnchantmentCategory CORE_ARMOR = EnchantmentCategory.create((String)"CORE_ARMOR", i -> EnchantmentCategory.ARMOR_CHEST.m_7454_(i) || EnchantmentCategory.ARMOR_LEGS.m_7454_(i));
    static Configuration enchInfoConfig;

    public EnchModule() {
        if (FMLEnvironment.dist.isClient()) {
            FMLJavaModLoadingContext.get().getModEventBus().register(EnchModuleClient.class);
        }
        Ench.bootstrap();
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        Apotheosis.HELPER.registerProvider(factory -> {
            Ingredient pot = Apotheosis.potionIngredient(Potions.f_43587_);
            factory.addShaped(Ench.Blocks.HELLSHELF.get(), 3, 3, new Object[]{Blocks.f_50197_, Blocks.f_50197_, Blocks.f_50197_, Items.f_42585_, "forge:bookshelves", pot, Blocks.f_50197_, Blocks.f_50197_, Blocks.f_50197_});
            factory.addShaped(Ench.Items.PRISMATIC_WEB, 3, 3, new Object[]{null, Items.f_42695_, null, Items.f_42695_, Blocks.f_50033_, Items.f_42695_, null, Items.f_42695_, null});
            ItemStack book = new ItemStack((ItemLike)Items.f_42517_);
            ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
            ItemStack blaze = new ItemStack((ItemLike)Items.f_42585_);
            factory.addShaped((Object)new ItemStack((ItemLike)Ench.Items.HELMET_TOME.get(), 5), 3, 2, new Object[]{book, book, book, book, blaze, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Ench.Items.CHESTPLATE_TOME.get(), 8), 3, 3, new Object[]{book, blaze, book, book, book, book, book, book, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Ench.Items.LEGGINGS_TOME.get(), 7), 3, 3, new Object[]{book, null, book, book, blaze, book, book, book, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Ench.Items.BOOTS_TOME.get(), 4), 3, 2, new Object[]{book, null, book, book, blaze, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Ench.Items.WEAPON_TOME.get(), 2), 1, 3, new Object[]{book, book, new ItemStack((ItemLike)Items.f_42593_)});
            factory.addShaped((Object)new ItemStack((ItemLike)Ench.Items.PICKAXE_TOME.get(), 3), 3, 3, new Object[]{book, book, book, null, blaze, null, null, stick, null});
            factory.addShaped((Object)new ItemStack((ItemLike)Ench.Items.FISHING_TOME.get(), 2), 3, 3, new Object[]{null, null, blaze, null, stick, book, stick, null, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Ench.Items.BOW_TOME.get(), 3), 3, 3, new Object[]{null, stick, book, blaze, null, book, null, stick, book});
            factory.addShapeless((Object)new ItemStack((ItemLike)Ench.Items.OTHER_TOME.get(), 6), new Object[]{book, book, book, book, book, book, blaze});
            factory.addShaped((Object)new ItemStack((ItemLike)Ench.Items.SCRAP_TOME.get(), 8), 3, 3, new Object[]{book, book, book, book, Blocks.f_50322_, book, book, book, book});
            Ingredient maxHellshelf = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Ench.Blocks.INFUSED_HELLSHELF.get()});
            factory.addShaped(Ench.Blocks.BLAZING_HELLSHELF.get(), 3, 3, new Object[]{null, Items.f_42613_, null, Items.f_42613_, maxHellshelf, Items.f_42613_, Items.f_42593_, Items.f_42593_, Items.f_42593_});
            factory.addShaped(Ench.Blocks.GLOWING_HELLSHELF.get(), 3, 3, new Object[]{null, Blocks.f_50141_, null, null, maxHellshelf, null, Blocks.f_50141_, null, Blocks.f_50141_});
            factory.addShaped(Ench.Blocks.SEASHELF.get(), 3, 3, new Object[]{Blocks.f_50378_, Blocks.f_50378_, Blocks.f_50378_, Apotheosis.potionIngredient(Potions.f_43599_), "forge:bookshelves", Items.f_42529_, Blocks.f_50378_, Blocks.f_50378_, Blocks.f_50378_});
            Ingredient maxSeashelf = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Ench.Blocks.INFUSED_SEASHELF.get()});
            factory.addShaped(Ench.Blocks.CRYSTAL_SEASHELF.get(), 3, 3, new Object[]{null, Items.f_42696_, null, null, maxSeashelf, null, Items.f_42696_, null, Items.f_42696_});
            factory.addShaped(Ench.Blocks.HEART_SEASHELF.get(), 3, 3, new Object[]{null, Items.f_42716_, null, Items.f_42695_, maxSeashelf, Items.f_42695_, Items.f_42695_, Items.f_42695_, Items.f_42695_});
            factory.addShaped(Ench.Blocks.PEARL_ENDSHELF.get(), 3, 3, new Object[]{Items.f_42001_, null, Items.f_42001_, Items.f_42584_, Ench.Blocks.ENDSHELF.get(), Items.f_42584_, Items.f_42001_, null, Items.f_42001_});
            factory.addShaped(Ench.Blocks.DRACONIC_ENDSHELF.get(), 3, 3, new Object[]{null, Items.f_42683_, null, Items.f_42584_, Ench.Blocks.ENDSHELF.get(), Items.f_42584_, Items.f_42584_, Items.f_42584_, Items.f_42584_});
            factory.addShaped(Ench.Blocks.BEESHELF.get(), 3, 3, new Object[]{Items.f_42784_, Items.f_42786_, Items.f_42784_, Items.f_42788_, "forge:bookshelves", Items.f_42788_, Items.f_42784_, Items.f_42786_, Items.f_42784_});
            factory.addShaped(Ench.Blocks.MELONSHELF.get(), 3, 3, new Object[]{Items.f_42028_, Items.f_42028_, Items.f_42028_, Items.f_42546_, "forge:bookshelves", Items.f_42546_, Items.f_42028_, Items.f_42028_, Items.f_42028_});
        });
        MinecraftForge.EVENT_BUS.register((Object)new EnchModuleEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        e.enqueueWork(() -> {
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.HELLSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.INFUSED_HELLSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.BLAZING_HELLSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.GLOWING_HELLSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.SEASHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.INFUSED_SEASHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.CRYSTAL_SEASHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.HEART_SEASHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.DORMANT_DEEPSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.DEEPSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.ECHOING_DEEPSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.SOUL_TOUCHED_DEEPSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.ECHOING_SCULKSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.SOUL_TOUCHED_SCULKSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.ENDSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.PEARL_ENDSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.DRACONIC_ENDSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.BEESHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.MELONSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.STONESHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.LIBRARY.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.RECTIFIER.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.RECTIFIER_T2.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.RECTIFIER_T3.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.SIGHTSHELF.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.SIGHTSHELF_T2.get()));
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.ENDER_LIBRARY.get()));
            DispenserBlock.m_52672_((ItemLike)Items.f_42574_, (DispenseItemBehavior)new ShearsDispenseItemBehavior());
            TabFillingRegistry.register((ResourceKey)Ench.Tabs.ENCH.getKey(), (Supplier[])new Supplier[]{Ench.Items.HELLSHELF, Ench.Items.INFUSED_HELLSHELF, Ench.Items.BLAZING_HELLSHELF, Ench.Items.GLOWING_HELLSHELF, Ench.Items.SEASHELF, Ench.Items.INFUSED_SEASHELF, Ench.Items.CRYSTAL_SEASHELF, Ench.Items.HEART_SEASHELF, Ench.Items.DORMANT_DEEPSHELF, Ench.Items.DEEPSHELF, Ench.Items.ECHOING_DEEPSHELF, Ench.Items.SOUL_TOUCHED_DEEPSHELF, Ench.Items.ECHOING_SCULKSHELF, Ench.Items.SOUL_TOUCHED_SCULKSHELF, Ench.Items.ENDSHELF, Ench.Items.PEARL_ENDSHELF, Ench.Items.DRACONIC_ENDSHELF, Ench.Items.BEESHELF, Ench.Items.MELONSHELF, Ench.Items.STONESHELF, Ench.Items.RECTIFIER, Ench.Items.RECTIFIER_T2, Ench.Items.RECTIFIER_T3, Ench.Items.SIGHTSHELF, Ench.Items.SIGHTSHELF_T2, Ench.Items.LIBRARY, Ench.Items.ENDER_LIBRARY});
            TabFillingRegistry.register((ResourceKey)Ench.Tabs.ENCH.getKey(), (Supplier[])new Supplier[]{Ench.Items.HELMET_TOME, Ench.Items.CHESTPLATE_TOME, Ench.Items.LEGGINGS_TOME, Ench.Items.BOOTS_TOME, Ench.Items.WEAPON_TOME, Ench.Items.BOW_TOME, Ench.Items.PICKAXE_TOME, Ench.Items.FISHING_TOME, Ench.Items.OTHER_TOME, Ench.Items.SCRAP_TOME, Ench.Items.IMPROVED_SCRAP_TOME, Ench.Items.EXTRACTION_TOME});
            TabFillingRegistry.register((ResourceKey)Ench.Tabs.ENCH.getKey(), (Supplier[])new Supplier[]{Ench.Items.PRISMATIC_WEB, Ench.Items.INERT_TRIDENT, Ench.Items.WARDEN_TENDRIL, Ench.Items.INFUSED_BREATH});
            EnchModule.fill((ResourceKey<CreativeModeTab>)Ench.Tabs.ENCH.getKey(), new Supplier[]{Ench.Enchantments.BERSERKERS_FURY, Ench.Enchantments.CHAINSAW, Ench.Enchantments.CHROMATIC, Ench.Enchantments.CRESCENDO, Ench.Enchantments.EARTHS_BOON, Ench.Enchantments.ENDLESS_QUIVER, Ench.Enchantments.EXPLOITATION, Ench.Enchantments.GROWTH_SERUM, Ench.Enchantments.ICY_THORNS, Ench.Enchantments.KNOWLEDGE, Ench.Enchantments.LIFE_MENDING, Ench.Enchantments.MINERS_FERVOR, Ench.Enchantments.NATURES_BLESSING, Ench.Enchantments.OBLITERATION, Ench.Enchantments.REBOUNDING, Ench.Enchantments.REFLECTIVE, Ench.Enchantments.SCAVENGER, Ench.Enchantments.SHIELD_BASH, Ench.Enchantments.SPEARFISHING, Ench.Enchantments.SPLITTING, Ench.Enchantments.STABLE_FOOTING, Ench.Enchantments.TEMPTING});
        });
        if (ModList.get().isLoaded("theoneprobe")) {
            EnchTOPPlugin.register();
        }
        EnchantingStatRegistry.INSTANCE.registerToBus();
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new EnchModuleClient());
        e.enqueueWork(EnchModuleClient::init);
    }

    @SubscribeEvent
    public void miscRegistration(RegisterEvent e) {
        if (e.getForgeRegistry() == ForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS.get()) {
            e.getForgeRegistry().register("warden_tendril", WardenLootModifier.CODEC);
        }
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<BlockEntityType<?>> e) {
        e.getRegistry().register((Object)new BlockEntityType(AnvilTile::new, (Set)ImmutableSet.of((Object)Blocks.f_50322_, (Object)Blocks.f_50323_, (Object)Blocks.f_50324_), null), "anvil");
        BlockEntityType.f_58928_.f_58914_ = ApothEnchantTile::new;
        BlockEntityType.f_58928_.f_58915_ = ImmutableSet.of((Object)Blocks.f_50201_);
        e.getRegistry().register((Object)new BlockEntityType(EnchLibraryTile.BasicLibraryTile::new, (Set)ImmutableSet.of((Object)((Block)Ench.Blocks.LIBRARY.get())), null), "library");
        e.getRegistry().register((Object)new BlockEntityType(EnchLibraryTile.EnderLibraryTile::new, (Set)ImmutableSet.of((Object)((Block)Ench.Blocks.ENDER_LIBRARY.get())), null), "ender_library");
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<MenuType<?>> e) {
        e.getRegistry().register((Object)MenuUtil.type(ApothEnchantmentMenu::new), "enchanting_table");
        e.getRegistry().register((Object)MenuUtil.posType(EnchLibraryContainer::new), "library");
    }

    @SubscribeEvent
    public void recipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((Object)EnchantingRecipe.SERIALIZER, "enchanting");
        e.getRegistry().register((Object)KeepNBTEnchantingRecipe.SERIALIZER, "keep_nbt_enchanting");
    }

    @SubscribeEvent
    public void particles(RegistryEvent.Register<ParticleType<?>> e) {
        e.getRegistry().registerAll(new Object[]{new SimpleParticleType(false), "enchant_fire", new SimpleParticleType(false), "enchant_water", new SimpleParticleType(false), "enchant_sculk", new SimpleParticleType(false), "enchant_end"});
    }

    @SubscribeEvent
    public void handleIMC(InterModProcessEvent e) {
        e.getIMCStream(ENCH_HARD_CAP_IMC::equals).forEach(msg -> {
            try {
                EnchantmentInstance data = (EnchantmentInstance)msg.messageSupplier().get();
                if (data != null && data.f_44947_ != null && data.f_44948_ > 0) {
                    ENCH_HARD_CAPS.put((Object)data.f_44947_, data.f_44948_);
                } else {
                    LOGGER.error("Failed to process IMC message with method {} from {} (invalid values passed).", (Object)msg.method(), (Object)msg.senderModId());
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception thrown during IMC message with method {} from {}.", (Object)msg.method(), (Object)msg.senderModId());
                ex.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll(new Object[]{new ApothAnvilBlock(), new ResourceLocation("minecraft", "anvil"), new ApothAnvilBlock(), new ResourceLocation("minecraft", "chipped_anvil"), new ApothAnvilBlock(), new ResourceLocation("minecraft", "damaged_anvil")});
        PlaceboUtil.registerOverride((Block)Blocks.f_50201_, (Block)new ApothEnchantBlock(), (String)"apotheosis");
    }

    private static Block shelf(BlockBehaviour.Properties props, float strength) {
        return EnchModule.shelf(props, strength, () -> ParticleTypes.f_123809_);
    }

    private static Block shelf(BlockBehaviour.Properties props, float strength, Supplier<? extends ParticleOptions> particle) {
        props.m_60978_(strength);
        return new TypedShelfBlock(props, particle);
    }

    private static Block sculkShelf(float strength, Supplier<? extends ParticleOptions> particle) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60918_(SoundType.f_56742_).m_60978_(strength).m_60977_().m_60999_();
        return new TypedShelfBlock.SculkShelfBlock(props, particle);
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll(new Object[]{new ApothAnvilItem(Blocks.f_50322_), new ResourceLocation("minecraft", "anvil"), new ApothAnvilItem(Blocks.f_50323_), new ResourceLocation("minecraft", "chipped_anvil"), new ApothAnvilItem(Blocks.f_50324_), new ResourceLocation("minecraft", "damaged_anvil")});
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().registerAll(new Object[]{new BaneEnchant(Enchantment.Rarity.UNCOMMON, MobType.f_21642_, EquipmentSlot.MAINHAND), new ResourceLocation("minecraft", "bane_of_arthropods"), new BaneEnchant(Enchantment.Rarity.UNCOMMON, MobType.f_21641_, EquipmentSlot.MAINHAND), new ResourceLocation("minecraft", "smite"), new BaneEnchant(Enchantment.Rarity.COMMON, MobType.f_21640_, EquipmentSlot.MAINHAND), new ResourceLocation("minecraft", "sharpness"), new BaneEnchant(Enchantment.Rarity.UNCOMMON, MobType.f_21643_, EquipmentSlot.MAINHAND), "bane_of_illagers", new DefenseEnchant(Enchantment.Rarity.COMMON, ProtectionEnchantment.Type.ALL, ARMOR), new ResourceLocation("minecraft", "protection"), new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.FIRE, ARMOR), new ResourceLocation("minecraft", "fire_protection"), new DefenseEnchant(Enchantment.Rarity.RARE, ProtectionEnchantment.Type.EXPLOSION, ARMOR), new ResourceLocation("minecraft", "blast_protection"), new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.PROJECTILE, ARMOR), new ResourceLocation("minecraft", "projectile_protection"), new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.FALL, EquipmentSlot.FEET), new ResourceLocation("minecraft", "feather_falling")});
    }

    public static EnchantmentInfo getEnchInfo(Enchantment ench) {
        if (!Apotheosis.enableEnch) {
            return ENCHANTMENT_INFO.computeIfAbsent(ench, EnchantmentInfo::new);
        }
        EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
        if (enchInfoConfig == null) {
            return new EnchantmentInfo(ench);
        }
        if (info == null) {
            info = EnchantmentInfo.load(ench, enchInfoConfig);
            ENCHANTMENT_INFO.put(ench, info);
            if (enchInfoConfig.hasChanged()) {
                enchInfoConfig.save();
            }
            LOGGER.error("Had to late load enchantment info for {}, this is a bug in the mod {} as they are registering late!", (Object)ForgeRegistries.ENCHANTMENTS.getKey((Object)ench), (Object)ForgeRegistries.ENCHANTMENTS.getKey((Object)ench).m_135827_());
        }
        return info;
    }

    public static int getDefaultMax(Enchantment ench) {
        int level = ench.m_6586_();
        if (level == 1) {
            return 1;
        }
        EnchantmentInfo.PowerFunc minFunc = EnchantmentInfo.defaultMin(ench);
        int max = (int)(EnchantingStatRegistry.getAbsoluteMaxEterna() * 4.0f);
        int minPower = minFunc.getPower(level);
        if (minPower >= max) {
            return level;
        }
        int lastPower = minPower;
        while (minPower < max) {
            if (lastPower == (minPower = minFunc.getPower(++level))) {
                return level;
            }
            if (minPower > max) {
                return level - 1;
            }
            lastPower = minPower;
        }
        return level;
    }

    @SafeVarargs
    public static void fill(ResourceKey<CreativeModeTab> tab, Supplier<? extends Enchantment> ... enchants) {
        Arrays.stream(enchants).map(EnchModule::enchFiller).forEach(filler -> TabFillingRegistry.register((ITabFiller)filler, (ResourceKey[])new ResourceKey[]{tab}));
    }

    public static ITabFiller enchFiller(Supplier<? extends Enchantment> e) {
        return (tab, output) -> {
            Enchantment ench = (Enchantment)e.get();
            int maxLevel = EnchHooks.getMaxLevel(ench);
            output.m_246267_(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(ench, maxLevel)), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            for (int level = 1; level <= maxLevel; ++level) {
                output.m_246267_(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(ench, level)), CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
            }
        };
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        enchInfoConfig = new Configuration(new File(Apotheosis.configDir, "enchantments.cfg"));
        enchInfoConfig.setTitle("Apotheosis Enchantment Information");
        enchInfoConfig.setComment("This file contains configurable data for each enchantment.\nThe names of each category correspond to the registry names of every loaded enchantment.");
        ENCHANTMENT_INFO.clear();
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            ENCHANTMENT_INFO.put(ench, EnchantmentInfo.load(ench, enchInfoConfig));
        }
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
            for (int i = 1; i <= info.getMaxLevel(); ++i) {
                if (info.getMinPower(i) <= info.getMaxPower(i)) continue;
                LOGGER.warn("Enchantment {} has min/max power {}/{} at level {}, making this level unobtainable.", (Object)ForgeRegistries.ENCHANTMENTS.getKey((Object)ench), (Object)info.getMinPower(i), (Object)info.getMaxPower(i), (Object)i);
            }
        }
        if (e == null && enchInfoConfig.hasChanged()) {
            enchInfoConfig.save();
        }
    }
}

