/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class AffixItemIngredient
extends AbstractIngredient {
    protected final DynamicHolder<LootRarity> rarity;
    protected ItemStack[] items;

    public AffixItemIngredient(DynamicHolder<LootRarity> rarity) {
        this.rarity = rarity;
    }

    public boolean test(ItemStack stack) {
        DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(stack);
        Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        return affixes.size() > 0 && rarity.isBound() && rarity == this.rarity;
    }

    public ItemStack[] m_43908_() {
        if (this.items == null) {
            this.items = AffixItemIngredient.createFakeDisplayItems((LootRarity)this.rarity.get()).toArray(new ItemStack[0]);
        }
        return this.items;
    }

    protected void invalidate() {
        super.invalidate();
        this.items = null;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        return new JsonObject();
    }

    public LootRarity getRarity() {
        return (LootRarity)this.rarity.get();
    }

    private static List<ItemStack> createFakeDisplayItems(LootRarity rarity) {
        LegacyRandomSource src = new LegacyRandomSource(0L);
        List<ItemStack> out = Arrays.asList(Items.f_42388_, Items.f_42390_, Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_).stream().map(ItemStack::new).toList();
        out.forEach(arg_0 -> AffixItemIngredient.lambda$createFakeDisplayItems$0(rarity, (RandomSource)src, arg_0));
        return out;
    }

    private static /* synthetic */ void lambda$createFakeDisplayItems$0(LootRarity rarity, RandomSource src, ItemStack stack) {
        LootController.createLootItem(stack, rarity, src);
        AffixHelper.setName(stack, (Component)Component.m_237110_((String)"text.apotheosis.any_x_item", (Object[])new Object[]{rarity.toComponent(), ""}).m_130948_(Style.f_131099_.m_131148_(rarity.getColor())));
    }

    public static class Serializer
    implements IIngredientSerializer<AffixItemIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public AffixItemIngredient parse(FriendlyByteBuf buffer) {
            DynamicHolder rarity = RarityRegistry.INSTANCE.holder(buffer.m_130281_());
            return new AffixItemIngredient((DynamicHolder<LootRarity>)rarity);
        }

        public AffixItemIngredient parse(JsonObject json) {
            DynamicHolder rarity = RarityRegistry.INSTANCE.holder(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"rarity")));
            return new AffixItemIngredient((DynamicHolder<LootRarity>)rarity);
        }

        public void write(FriendlyByteBuf buffer, AffixItemIngredient ingredient) {
            buffer.m_130085_(ingredient.rarity.getId());
        }
    }
}

