/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds;

import me.jellysquid.mods.sodium.client.gui.console.Console;
import me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel;
import me.jellysquid.mods.sodium.client.util.workarounds.GLContextInfo;
import me.jellysquid.mods.sodium.client.util.workarounds.driver.nvidia.NvidiaGLContextInfo;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostLaunchChecks {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Rubidium-PostlaunchChecks");

    public static void checkContext() {
        PostLaunchChecks.checkContextImplementation();
        if (PostLaunchChecks.isUsingPojavLauncher()) {
            PostLaunchChecks.showConsoleMessage(Component.m_237115_((String)"sodium.console.pojav_launcher"));
            PostLaunchChecks.logMessage("It appears that PojavLauncher is being used with an OpenGL compatibility layer. This will likely cause severe performance issues, graphical issues, and crashes when used with Rubidium. This configuration is not supported -- you are on your own!", new Object[0]);
        }
    }

    private static void checkContextImplementation() {
        GLContextInfo driver = PostLaunchChecks.getGraphicsContextInfo();
        if (driver == null) {
            LOGGER.warn("Could not retrieve identifying strings for OpenGL implementation");
            return;
        }
        LOGGER.info("OpenGL Vendor: {}", (Object)driver.vendor());
        LOGGER.info("OpenGL Renderer: {}", (Object)driver.renderer());
        LOGGER.info("OpenGL Version: {}", (Object)driver.version());
        if (PostLaunchChecks.isBrokenNvidiaDriverInstalled(driver)) {
            PostLaunchChecks.showConsoleMessage(Component.m_237115_((String)"sodium.console.broken_nvidia_driver"));
            PostLaunchChecks.logMessage("The NVIDIA graphics driver appears to be out of date. This will likely cause severe performance issues and crashes when used with Rubidium. The graphics driver should be updated to the latest version (version 536.23 or newer).", new Object[0]);
        }
    }

    @Nullable
    private static GLContextInfo getGraphicsContextInfo() {
        String vendor = GL11C.glGetString((int)7936);
        String renderer = GL11C.glGetString((int)7937);
        String version = GL11C.glGetString((int)7938);
        if (vendor == null || renderer == null || version == null) {
            return null;
        }
        return new GLContextInfo(vendor, renderer, version);
    }

    private static void showConsoleMessage(MutableComponent message) {
        Console.instance().logMessage(MessageLevel.SEVERE, (Component)message, 30.0);
    }

    private static void logMessage(String message, Object ... args) {
        LOGGER.error(message, args);
    }

    private static boolean isBrokenNvidiaDriverInstalled(GLContextInfo driver) {
        if (Util.m_137581_() != Util.OS.WINDOWS) {
            return false;
        }
        NvidiaGLContextInfo version = NvidiaGLContextInfo.tryParse(driver);
        if (version != null) {
            return version.isWithinRange(new NvidiaGLContextInfo(526, 47), new NvidiaGLContextInfo(536, 23));
        }
        return false;
    }

    private static boolean isUsingPojavLauncher() {
        String workingDirectory;
        if (System.getenv("POJAV_RENDERER") != null) {
            LOGGER.warn("Detected presence of environment variable POJAV_LAUNCHER, which seems to indicate we are running on Android");
            return true;
        }
        String librarySearchPaths = System.getProperty("java.library.path", null);
        if (librarySearchPaths != null) {
            for (String path : librarySearchPaths.split(":")) {
                if (!PostLaunchChecks.isKnownAndroidPathFragment(path)) continue;
                LOGGER.warn("Found a library search path which seems to be hosted in an Android filesystem: {}", (Object)path);
                return true;
            }
        }
        if ((workingDirectory = System.getProperty("user.home", null)) != null && PostLaunchChecks.isKnownAndroidPathFragment(workingDirectory)) {
            LOGGER.warn("Working directory seems to be hosted in an Android filesystem: {}", (Object)workingDirectory);
        }
        return false;
    }

    private static boolean isKnownAndroidPathFragment(String path) {
        return path.matches("/data/user/[0-9]+/net\\.kdt\\.pojavlaunch");
    }
}

