/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.basic;

import mekanism.api.security.ISecurityUtils;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.base.WrenchResult;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class BlockFluidTank
extends BlockTile.BlockTileModel<TileEntityFluidTank, Machine<TileEntityFluidTank>> {
    public BlockFluidTank(Machine<TileEntityFluidTank> type) {
        super(type, properties -> properties.m_284180_(BlockResourceInfo.STEEL.getMapColor()));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        FluidStack fluid;
        int ambientLight = super.getLightEmission(state, world, pos);
        if (ambientLight == 15) {
            return ambientLight;
        }
        TileEntityFluidTank tile = WorldUtils.getTileEntity(TileEntityFluidTank.class, world, pos);
        if (tile != null && !(fluid = tile.fluidTank.getFluid()).isEmpty()) {
            ambientLight = Math.max(ambientLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
        }
        return ambientLight;
    }

    @Override
    @Deprecated
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        TileEntityFluidTank tile = WorldUtils.getTileEntity(TileEntityFluidTank.class, (BlockGetter)world, pos, true);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return this.genericClientActivated(player, hand);
        }
        if (tile.tryWrench(state, player, hand, hit) != WrenchResult.PASS) {
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_()) {
            if (!ISecurityUtils.INSTANCE.canAccessOrDisplayError(player, (ICapabilityProvider)tile)) {
                return InteractionResult.FAIL;
            }
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_() && FluidUtils.handleTankInteraction(player, hand, stack, tile.fluidTank)) {
                player.m_150109_().m_6596_();
                return InteractionResult.SUCCESS;
            }
        }
        return tile.openGui(player);
    }
}

