/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mekanism.common.Mekanism;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import org.jetbrains.annotations.Nullable;

public record ConditionExistsCondition(@Nullable ICondition condition) implements ICondition
{
    private static final ResourceLocation NAME = Mekanism.rl("condition_exists");
    private static final ConditionExistsCondition DOES_NOT_EXIST = new ConditionExistsCondition(null);

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return this.condition != null && this.condition.test(context);
    }

    @Override
    public String toString() {
        return "condition_exists(" + this.condition + ")";
    }

    public static class Serializer
    implements IConditionSerializer<ConditionExistsCondition> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public void write(JsonObject json, ConditionExistsCondition value) {
            if (value.condition != null) {
                json.add("condition", (JsonElement)CraftingHelper.serialize((ICondition)value.condition));
            }
        }

        public ConditionExistsCondition read(JsonObject json) {
            JsonObject condition = GsonHelper.m_13841_((JsonObject)json, (String)"condition", null);
            if (condition == null) {
                return DOES_NOT_EXIST;
            }
            try {
                return new ConditionExistsCondition(CraftingHelper.getCondition((JsonObject)condition));
            }
            catch (JsonParseException e) {
                return DOES_NOT_EXIST;
            }
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

