/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.client.UncraftingScreen;
import twilightforest.compat.jei.FakeItemEntity;
import twilightforest.compat.jei.categories.CrumbleHornCategory;
import twilightforest.compat.jei.categories.JEIUncraftingCategory;
import twilightforest.compat.jei.categories.TransformationPowderCategory;
import twilightforest.compat.jei.renderers.EntityHelper;
import twilightforest.compat.jei.renderers.EntityRenderer;
import twilightforest.compat.jei.renderers.FakeItemEntityHelper;
import twilightforest.compat.jei.renderers.FakeItemEntityRenderer;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFMenuTypes;
import twilightforest.init.TFRecipes;
import twilightforest.inventory.UncraftingMenu;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public static final IIngredientType<EntityType> ENTITY_TYPE = () -> EntityType.class;
    public static final IIngredientType<FakeItemEntity> FAKE_ITEM_ENTITY = () -> FakeItemEntity.class;

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (!((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableEntireTable.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)TFBlocks.UNCRAFTING_TABLE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)TFBlocks.UNCRAFTING_TABLE.get()), new RecipeType[]{JEIUncraftingCategory.UNCRAFTING});
        }
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TFItems.TRANSFORMATION_POWDER.get()), new RecipeType[]{TransformationPowderCategory.TRANSFORMATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TFItems.CRUMBLE_HORN.get()), new RecipeType[]{CrumbleHornCategory.CRUMBLE_HORN});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(UncraftingMenu.class, (MenuType)TFMenuTypes.UNCRAFTING.get(), RecipeTypes.CRAFTING, 11, 9, 20, 36);
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(ENTITY_TYPE, Collections.emptyList(), (IIngredientHelper)new EntityHelper(), (IIngredientRenderer)new EntityRenderer(16));
        registration.register(FAKE_ITEM_ENTITY, Collections.emptyList(), (IIngredientHelper)new FakeItemEntityHelper(), (IIngredientRenderer)new FakeItemEntityRenderer(16));
    }

    public ResourceLocation getPluginUid() {
        return TwilightForestMod.prefix("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new JEIUncraftingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new TransformationPowderCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrumbleHornCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        if (!((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.get()).booleanValue()) {
            List recipes = manager.m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44107_);
            recipes = recipes.stream().filter(recipe -> !recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_41619_() && !recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_204117_(ItemTagGenerator.BANNED_UNCRAFTABLES) && ((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.reverseRecipeBlacklist.get()).booleanValue() == ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingRecipes.get()).contains(recipe.m_6423_().toString()) && ((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.flipUncraftingModIdList.get()).booleanValue() == ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.get()).contains(recipe.m_6423_().m_135827_())).collect(Collectors.toList());
            recipes.removeIf(recipe -> recipe instanceof ShapelessRecipe && (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.allowShapelessUncrafting.get() == false);
            recipes.addAll(manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TFRecipes.UNCRAFTING_RECIPE.get()));
            registration.addRecipes(JEIUncraftingCategory.UNCRAFTING, recipes);
        } else if (!((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableEntireTable.get()).booleanValue()) {
            ArrayList recipes = new ArrayList(manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TFRecipes.UNCRAFTING_RECIPE.get()));
            registration.addRecipes(JEIUncraftingCategory.UNCRAFTING, recipes);
        }
        registration.addRecipes(TransformationPowderCategory.TRANSFORMATION, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TFRecipes.TRANSFORM_POWDER_RECIPE.get()));
        registration.addRecipes(CrumbleHornCategory.CRUMBLE_HORN, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TFRecipes.CRUMBLE_RECIPE.get()));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(UncraftingScreen.class, 34, 33, 27, 20, new RecipeType[]{JEIUncraftingCategory.UNCRAFTING});
        registration.addRecipeClickArea(UncraftingScreen.class, 115, 33, 27, 20, new RecipeType[]{RecipeTypes.CRAFTING});
    }
}

