/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib;

import dev.shadowsoffire.attributeslib.api.ALObjects;
import dev.shadowsoffire.attributeslib.client.AttributesLibClient;
import dev.shadowsoffire.attributeslib.compat.CuriosCompat;
import dev.shadowsoffire.attributeslib.impl.AttributeEvents;
import dev.shadowsoffire.attributeslib.packet.CritParticleMessage;
import dev.shadowsoffire.placebo.network.MessageHelper;
import dev.shadowsoffire.placebo.network.MessageProvider;
import dev.shadowsoffire.placebo.registry.DeferredHelper;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="attributeslib")
public class AttributesLib {
    public static final String MODID = "attributeslib";
    public static final Logger LOGGER = LogManager.getLogger((String)"attributeslib");
    public static final DeferredHelper R = DeferredHelper.create((String)"attributeslib");
    public static float localAtkStrength = 1.0f;
    public static int knowledgeMult = 4;
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("attributeslib", "attributeslib")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();

    public AttributesLib() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new AttributeEvents());
        if (FMLEnvironment.dist.isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new AttributesLibClient());
            FMLJavaModLoadingContext.get().getModEventBus().register(AttributesLibClient.class);
        }
        MessageHelper.registerMessage((SimpleChannel)CHANNEL, (int)0, (MessageProvider)new CritParticleMessage.Provider());
        ALObjects.bootstrap();
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        MinecraftForge.EVENT_BUS.register(ALObjects.MobEffects.KNOWLEDGE.get());
        e.enqueueWork(() -> MobEffects.f_19610_.m_19472_(Attributes.f_22277_, "f8c3de3d-1fea-4d7c-a8b0-22f63c4c3454", -0.75, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    @SubscribeEvent
    public void applyAttribs(EntityAttributeModificationEvent e) {
        e.getTypes().forEach(type -> AttributesLib.addAll((EntityType<? extends LivingEntity>)type, (arg_0, arg_1) -> ((EntityAttributeModificationEvent)e).add(arg_0, arg_1), ALObjects.Attributes.DRAW_SPEED, ALObjects.Attributes.CRIT_CHANCE, ALObjects.Attributes.CRIT_DAMAGE, ALObjects.Attributes.COLD_DAMAGE, ALObjects.Attributes.FIRE_DAMAGE, ALObjects.Attributes.LIFE_STEAL, ALObjects.Attributes.CURRENT_HP_DAMAGE, ALObjects.Attributes.OVERHEAL, ALObjects.Attributes.GHOST_HEALTH, ALObjects.Attributes.MINING_SPEED, ALObjects.Attributes.ARROW_DAMAGE, ALObjects.Attributes.ARROW_VELOCITY, ALObjects.Attributes.EXPERIENCE_GAINED, ALObjects.Attributes.HEALING_RECEIVED, ALObjects.Attributes.ARMOR_PIERCE, ALObjects.Attributes.ARMOR_SHRED, ALObjects.Attributes.PROT_PIERCE, ALObjects.Attributes.PROT_SHRED, ALObjects.Attributes.DODGE_CHANCE, ALObjects.Attributes.ELYTRA_FLIGHT, ALObjects.Attributes.CREATIVE_FLIGHT));
        e.add(EntityType.f_20532_, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 0.6);
    }

    @SafeVarargs
    private static void addAll(EntityType<? extends LivingEntity> type, BiConsumer<EntityType<? extends LivingEntity>, Attribute> add, RegistryObject<? extends Attribute> ... attribs) {
        for (RegistryObject<? extends Attribute> a : attribs) {
            add.accept(type, (Attribute)a.get());
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        AttributeSupplier playerAttribs = DefaultAttributes.m_22297_((EntityType)EntityType.f_20532_);
        for (Attribute attr : ForgeRegistries.ATTRIBUTES.getValues()) {
            if (!playerAttribs.m_22258_(attr)) continue;
            attr.m_22084_(true);
        }
        if (ModList.get().isLoaded("curios")) {
            e.enqueueWork(CuriosCompat::init);
        }
    }

    public static TooltipFlag getTooltipFlag() {
        if (FMLEnvironment.dist.isClient()) {
            return ClientAccess.getTooltipFlag();
        }
        return TooltipFlag.f_256752_;
    }

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(MODID, path);
    }

    private static class ClientAccess {
        private ClientAccess() {
        }

        static TooltipFlag getTooltipFlag() {
            return Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_;
        }
    }
}

