/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.colytra.platform;

import com.illusivesoulworks.colytra.common.ColytraConfig;
import com.illusivesoulworks.colytra.platform.services.IPlatform;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgePlatform
implements IPlatform {
    @Override
    public Enchantment getEnchantment(ResourceLocation resourceLocation) {
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(resourceLocation);
    }

    @Override
    public Item getItem(ResourceLocation resourceLocation) {
        return (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
    }

    @Override
    public void extractEnergy(ItemStack stack) {
        LazyOptional energyStorage = stack.getCapability(ForgeCapabilities.ENERGY);
        energyStorage.ifPresent(energy -> energy.extractEnergy(((Integer)ColytraConfig.SERVER.energyCost.get()).intValue(), false));
    }

    @Override
    public boolean hasEnergy(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    @Override
    public boolean canExtractEnergy(ItemStack stack) {
        LazyOptional energyStorage = stack.getCapability(ForgeCapabilities.ENERGY);
        return energyStorage.map(energy -> energy.canExtract() && energy.getEnergyStored() > (Integer)ColytraConfig.SERVER.energyCost.get()).orElse(false);
    }
}

