/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.network;

import java.util.function.Supplier;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ActiveStateSyncMessage {
    public CompoundTag activeTag;
    public int id;

    public static ActiveStateSyncMessage decode(FriendlyByteBuf buf) {
        ActiveStateSyncMessage msg = new ActiveStateSyncMessage();
        msg.id = buf.readInt();
        msg.activeTag = buf.m_130260_();
        return msg;
    }

    public static void encode(ActiveStateSyncMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.id);
        buf.m_130079_(msg.activeTag);
    }

    public static void handle(ActiveStateSyncMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (!msg.activeTag.m_128403_("BladeUniqueId")) {
                return;
            }
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity target = Minecraft.m_91087_().f_91073_.m_6815_(msg.id);
            if (target instanceof LivingEntity) {
                ItemStack stack = ((LivingEntity)target).m_21120_(InteractionHand.MAIN_HAND);
                if (stack.m_41619_()) {
                    return;
                }
                if (!(stack.m_41720_() instanceof ItemSlashBlade)) {
                    return;
                }
                stack.getCapability(ItemSlashBlade.BLADESTATE).filter(state -> state.getUniqueId().equals(msg.activeTag.m_128342_("BladeUniqueId"))).ifPresent(state -> state.setActiveState(msg.activeTag));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

