/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import com.nosiphus.furniture.core.ModSounds;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DoorBellBlock
extends FurnitureHorizontalBlock {
    public static final BooleanProperty ACTIVATED = BooleanProperty.m_61465_((String)"activated");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public DoorBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] WOOD = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.4, (double)4.8, (double)6.4, (double)16.0, (double)11.2, (double)9.6), (Direction)Direction.EAST));
        VoxelShape[] BUTTON = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)13.6, (double)7.2, (double)7.2, (double)14.4, (double)8.8, (double)8.8), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(WOOD[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVATED});
    }

    public InteractionResult m_6227_(final BlockState state, final Level level, final BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)), 2);
        level.m_5594_(player, pos, (SoundEvent)ModSounds.BLOCK_DOOR_BELL_RING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)), 2);
            }
        }, 50L);
        return InteractionResult.SUCCESS;
    }
}

