/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.client.event;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.client.gui.widget.button.IconButton;
import com.mrcrayfish.furniture.item.CreativeItem;
import com.nosiphus.furniture.client.gui.widget.button.TagButton;
import com.nosiphus.furniture.common.ModTags;
import com.nosiphus.furniture.core.ModBlocks;
import com.nosiphus.furniture.core.ModCreativeTabs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CreativeScreenEvents {
    private static final ResourceLocation ICONS = new ResourceLocation("cfm", "textures/gui/icons.png");
    private static int startIndex;
    private static CreativeModeTab lastTab;
    private List<TagFilter> filters;
    private List<TagButton> buttons;
    private Button btnScrollUp;
    private Button btnScrollDown;
    private Button btnEnableAll;
    private Button btnDisableAll;
    private int guiCenterX = 0;
    private int guiCenterY = 0;

    @SubscribeEvent
    public void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        this.filters = null;
    }

    @SubscribeEvent
    public void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            if (this.filters == null) {
                this.compileItems();
            }
            this.guiCenterX = creativeScreen.getGuiLeft();
            this.guiCenterY = creativeScreen.getGuiTop();
            this.buttons = this.createTagButtons();
            this.buttons.forEach(arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0));
            this.btnScrollUp = new IconButton(this.guiCenterX - 22, this.guiCenterY - 12, button -> {
                if (startIndex > 0) {
                    --startIndex;
                }
                this.updateTagButtons();
            }, ICONS, 64, 0);
            event.addListener((GuiEventListener)this.btnScrollUp);
            this.btnScrollDown = new IconButton(this.guiCenterX - 22, this.guiCenterY + 127, button -> {
                if (startIndex <= this.filters.size() - 4 - 1) {
                    ++startIndex;
                }
                this.updateTagButtons();
            }, ICONS, 80, 0);
            event.addListener((GuiEventListener)this.btnScrollDown);
            this.btnEnableAll = new IconButton(this.guiCenterX - 50, this.guiCenterY + 10, button -> {
                this.filters.forEach(filters -> filters.setEnabled(true));
                this.buttons.forEach(TagButton::updateState);
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreativeModeInventoryScreen) {
                    this.updateItems((CreativeModeInventoryScreen)screen);
                }
            }, ICONS, 96, 0);
            event.addListener((GuiEventListener)this.btnEnableAll);
            this.btnEnableAll.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.button.cfm.enable_filters")));
            this.btnDisableAll = new IconButton(this.guiCenterX - 50, this.guiCenterY + 32, button -> {
                this.filters.forEach(filters -> filters.setEnabled(false));
                this.buttons.forEach(TagButton::updateState);
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreativeModeInventoryScreen) {
                    this.updateItems((CreativeModeInventoryScreen)screen);
                }
            }, ICONS, 112, 0);
            event.addListener((GuiEventListener)this.btnDisableAll);
            this.btnDisableAll.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.button.cfm.disable_filters")));
            this.onSwitchCreativeTab(CreativeModeInventoryScreen.f_98507_, creativeScreen);
        }
    }

    @SubscribeEvent
    public void onScreenDrawPost(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            this.guiCenterX = creativeScreen.getGuiLeft();
            this.guiCenterY = creativeScreen.getGuiTop();
            CreativeModeTab tab = CreativeModeInventoryScreen.f_98507_;
            if (lastTab != tab) {
                this.onSwitchCreativeTab(tab, creativeScreen);
                lastTab = tab;
            }
        }
    }

    private void onSwitchCreativeTab(CreativeModeTab tab, CreativeModeInventoryScreen screen) {
        if (tab == ModCreativeTabs.MAIN.get()) {
            this.btnScrollUp.f_93624_ = true;
            this.btnScrollDown.f_93624_ = true;
            this.btnEnableAll.f_93624_ = true;
            this.btnDisableAll.f_93624_ = true;
            this.updateTagButtons();
            this.updateItems(screen);
        } else {
            this.btnScrollUp.f_93624_ = false;
            this.btnScrollDown.f_93624_ = false;
            this.btnEnableAll.f_93624_ = false;
            this.btnDisableAll.f_93624_ = false;
            this.buttons.forEach(button -> {
                button.f_93624_ = false;
            });
        }
    }

    private List<TagButton> createTagButtons() {
        ArrayList<TagButton> tagButtons = new ArrayList<TagButton>();
        for (TagFilter filter : this.filters) {
            TagButton tagButton = new TagButton(this.guiCenterX - 28, this.guiCenterY, filter, button -> {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreativeModeInventoryScreen) {
                    CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
                    this.updateItems(creativeScreen);
                }
            });
            tagButton.f_93624_ = false;
            tagButtons.add(tagButton);
        }
        return tagButtons;
    }

    private void updateTagButtons() {
        this.buttons.forEach(button -> {
            button.f_93624_ = false;
        });
        for (int i = startIndex; i < startIndex + 4 && i < this.buttons.size(); ++i) {
            TagButton button2 = this.buttons.get(i);
            button2.m_253211_(this.guiCenterY + 29 * (i - startIndex) + 11);
            button2.f_93624_ = true;
        }
        this.btnScrollUp.f_93623_ = startIndex > 0;
        this.btnScrollDown.f_93623_ = startIndex <= this.filters.size() - 4 - 1;
    }

    private void updateItems(CreativeModeInventoryScreen screen) {
        CreativeModeInventoryScreen.ItemPickerMenu menu = (CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_();
        LinkedHashSet<Item> categorisedItems = new LinkedHashSet<Item>();
        for (TagFilter filter : this.filters) {
            if (!filter.isEnabled()) continue;
            categorisedItems.addAll(filter.getItems());
        }
        NonNullList newItems = NonNullList.m_122779_();
        for (Item item : categorisedItems) {
            if (item instanceof CreativeItem) {
                CreativeItem creativeItem = (CreativeItem)item;
                creativeItem.fill(arg_0 -> newItems.add(arg_0));
                continue;
            }
            newItems.add((Object)new ItemStack((ItemLike)item));
        }
        menu.f_98639_.clear();
        menu.f_98639_.addAll((Collection)newItems);
        menu.f_98639_.sort(Comparator.comparingInt(o -> Item.m_41393_((Item)o.m_41720_())));
        menu.m_98642_(0.0f);
    }

    private void compileItems() {
        TagFilter[] filters = new TagFilter[]{new TagFilter(ModTags.Items.GENERAL, new ItemStack((ItemLike)ModBlocks.CHAIR_WHITE_MODERN.get())), new TagFilter(ModTags.Items.STORAGE, new ItemStack((ItemLike)ModBlocks.CABINET_WHITE_MODERN.get())), new TagFilter(ModTags.Items.BEDROOM, new ItemStack((ItemLike)ModBlocks.DESK_WHITE_MODERN.get())), new TagFilter(ModTags.Items.KITCHEN, new ItemStack((ItemLike)ModBlocks.KITCHEN_COUNTER_WHITE_MODERN.get())), new TagFilter(ModTags.Items.BATHROOM, new ItemStack((ItemLike)ModBlocks.TOILET_LIGHT.get())), new TagFilter(ModTags.Items.OUTDOORS, new ItemStack((ItemLike)ModBlocks.INFLATABLE_CASTLE_WHITE.get())), new TagFilter(ModTags.Items.FESTIVE, new ItemStack((ItemLike)ModBlocks.WREATH.get()))};
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).m_135827_().equals("nfm")).forEach(item -> ForgeRegistries.ITEMS.getHolder(item).ifPresent(holder -> holder.m_203616_().forEach(tagKey -> {
            for (TagFilter filter : filters) {
                if (tagKey != filter.getTag()) continue;
                filter.add((Item)item);
            }
        })));
        this.filters = new ArrayList<TagFilter>();
        this.filters.addAll(Arrays.asList(filters));
    }

    static {
        lastTab = CreativeModeTabs.m_257543_();
    }

    public static class TagFilter {
        private final List<Item> items = Lists.newArrayList();
        private final TagKey<Item> tag;
        private final Component name;
        private final ItemStack icon;
        private boolean enabled = true;

        public TagFilter(TagKey<Item> tag, ItemStack icon) {
            this.tag = tag;
            this.name = Component.m_237115_((String)String.format("gui.tag_filter.%s.%s", tag.f_203868_().m_135827_(), tag.f_203868_().m_135815_().replace("/", ".")));
            this.icon = icon;
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public Component getName() {
            return this.name;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void add(Item item) {
            this.items.add(item);
        }

        public void add(Block block) {
            this.items.add(Item.m_41439_((Block)block));
        }

        public List<Item> getItems() {
            return this.items;
        }
    }
}

