/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import net.caffeinemc.mods.sodium.api.vertex.serializer.VertexSerializer;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.QuadViewEntity;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public class GlyphToTerrainVertexSerializer
implements VertexSerializer {
    private static final int OFFSET_POSITION = 0;
    private static final int OFFSET_COLOR = 12;
    private static final int OFFSET_TEXTURE = 16;
    private static final int OFFSET_MID_TEXTURE = 42;
    private static final int OFFSET_OVERLAY = 24;
    private static final int OFFSET_LIGHT = 28;
    private static final int OFFSET_NORMAL = 32;
    private static final int OFFSET_TANGENT = 50;
    private static final QuadViewEntity.QuadViewEntityUnsafe quad = new QuadViewEntity.QuadViewEntityUnsafe();
    private static final Vector3f saveNormal = new Vector3f();
    private static int STRIDE = IrisVertexFormats.ENTITY.m_86020_();

    public void serialize(long src, long dst, int vertexCount) {
        float uSum = 0.0f;
        float vSum = 0.0f;
        for (int i = 0; i < vertexCount; ++i) {
            float u = MemoryUtil.memGetFloat((long)(src + 16L));
            float v = MemoryUtil.memGetFloat((long)(src + 16L + 4L));
            uSum += u;
            vSum += v;
            MemoryUtil.memPutFloat((long)(dst + 0L + 0L), (float)MemoryUtil.memGetFloat((long)(src + 0L)));
            MemoryUtil.memPutFloat((long)(dst + 0L + 4L), (float)MemoryUtil.memGetFloat((long)(src + 0L + 4L)));
            MemoryUtil.memPutFloat((long)(dst + 0L + 8L), (float)MemoryUtil.memGetFloat((long)(src + 0L + 8L)));
            MemoryUtil.memPutInt((long)(dst + 12L), (int)MemoryUtil.memGetInt((long)(src + 12L)));
            MemoryUtil.memPutFloat((long)(dst + 16L + 0L), (float)u);
            MemoryUtil.memPutFloat((long)(dst + 16L + 4L), (float)v);
            MemoryUtil.memPutInt((long)(dst + 28L), (int)MemoryUtil.memGetInt((long)(src + 28L - 4L)));
            MemoryUtil.memPutInt((long)(dst + 24L), (int)OverlayTexture.f_118083_);
            MemoryUtil.memPutShort((long)(dst + 36L), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedEntity()));
            MemoryUtil.memPutShort((long)(dst + 38L), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity()));
            MemoryUtil.memPutShort((long)(dst + 40L), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedItem()));
            src += (long)DefaultVertexFormat.f_85820_.m_86020_();
            dst += (long)IrisVertexFormats.ENTITY.m_86020_();
        }
        GlyphToTerrainVertexSerializer.endQuad(uSum, vSum, src, dst);
    }

    private static void endQuad(float uSum, float vSum, long src, long dst) {
        uSum *= 0.25f;
        vSum *= 0.25f;
        quad.setup(src, IrisVertexFormats.ENTITY.m_86020_());
        NormalHelper.computeFaceNormal(saveNormal, quad);
        float normalX = GlyphToTerrainVertexSerializer.saveNormal.x;
        float normalY = GlyphToTerrainVertexSerializer.saveNormal.y;
        float normalZ = GlyphToTerrainVertexSerializer.saveNormal.z;
        int normal = NormI8.pack(saveNormal);
        int tangent = NormalHelper.computeTangent(normalX, normalY, normalZ, quad);
        for (long vertex = 0L; vertex < 4L; ++vertex) {
            MemoryUtil.memPutFloat((long)(dst + 42L - (long)STRIDE * vertex), (float)uSum);
            MemoryUtil.memPutFloat((long)(dst + 46L - (long)STRIDE * vertex), (float)vSum);
            MemoryUtil.memPutInt((long)(dst + 32L - (long)STRIDE * vertex), (int)normal);
            MemoryUtil.memPutInt((long)(dst + 50L - (long)STRIDE * vertex), (int)tangent);
        }
    }
}

