/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPrismBlockEntity;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;

public class ManaPrismBlock
extends BotaniaWaterloggedBlock
implements EntityBlock,
ManaCollisionGhost {
    private static final VoxelShape SHAPE = ManaPrismBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public ManaPrismBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BotaniaStateProperties.HAS_LENS, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext econtext;
        if (context instanceof EntityCollisionContext && (econtext = (EntityCollisionContext)context).m_193113_() instanceof ManaBurstEntity) {
            return SHAPE;
        }
        return super.m_5939_(state, world, pos, context);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
            ManaPrismBlock.redstoneParticlesInShape(state, world, pos, rand);
        }
    }

    public static void redstoneParticlesInShape(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (rand.m_188499_()) {
            AABB localBox = state.m_60808_((BlockGetter)world, pos).m_83215_();
            double x = (double)pos.m_123341_() + localBox.f_82288_ + rand.m_188500_() * (localBox.f_82291_ - localBox.f_82288_);
            double y = (double)pos.m_123342_() + localBox.f_82289_ + rand.m_188500_() * (localBox.f_82292_ - localBox.f_82289_);
            double z = (double)pos.m_123343_() + localBox.f_82290_ + rand.m_188500_() * (localBox.f_82293_ - localBox.f_82290_);
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61448_, BotaniaStateProperties.HAS_LENS});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof ManaPrismBlockEntity)) {
            return InteractionResult.PASS;
        }
        ManaPrismBlockEntity prism = (ManaPrismBlockEntity)tile;
        ItemStack lens = prism.getItemHandler().m_8020_(0);
        ItemStack heldItem = player.m_21120_(hand);
        boolean playerHasLens = !heldItem.m_41619_() && heldItem.m_41720_() instanceof BasicLensItem;
        boolean lensIsSame = playerHasLens && ItemStack.m_150942_((ItemStack)heldItem, (ItemStack)lens);
        boolean mainHandEmpty = player.m_21205_().m_41619_();
        if (playerHasLens && !lensIsSame) {
            ItemStack toInsert = heldItem.m_41620_(1);
            if (!lens.m_41619_()) {
                player.m_150109_().m_150079_(lens);
            }
            prism.getItemHandler().m_6836_(0, toInsert);
            world.m_5594_(player, pos, BotaniaSounds.prismAddLens, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (!lens.m_41619_() && (mainHandEmpty || lensIsSame)) {
            player.m_150109_().m_150079_(lens);
            prism.getItemHandler().m_6836_(0, ItemStack.f_41583_);
            world.m_5594_(player, pos, BotaniaSounds.prismRemoveLens, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        boolean power = world.m_277086_(pos = context.m_8083_()) > 0;
        return (BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(power));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.m_277086_(pos) > 0;
        boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
        if (!world.f_46443_) {
            if (power && !powered) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
            } else if (!power && powered) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ManaPrismBlockEntity(pos, state);
    }

    @Override
    public ManaCollisionGhost.Behaviour getGhostBehaviour() {
        return ManaCollisionGhost.Behaviour.RUN_RECEIVER_TRIGGER;
    }
}

