/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.BotaniaGrassBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BlockLootProvider
implements DataProvider {
    private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final Function<Block, LootTable.Builder> SKIP = b -> {
        throw new RuntimeException("shouldn't be executed");
    };
    private final PackOutput.PathProvider pathProvider;
    private final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public BlockLootProvider(PackOutput packOutput) {
        this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables/blocks");
        for (Block b2 : BuiltInRegistries.f_256975_) {
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)b2);
            if (!"botania".equals(id.m_135827_())) continue;
            if (b2 instanceof SlabBlock) {
                this.functionTable.put(b2, BlockLootProvider::genSlab);
                continue;
            }
            if (b2 instanceof BotaniaDoubleFlowerBlock) {
                this.functionTable.put(b2, BlockLootProvider::genDoubleFlower);
                continue;
            }
            if (b2 instanceof BotaniaGrassBlock) {
                this.functionTable.put(b2, BlockLootProvider::genAltGrass);
                continue;
            }
            if (!id.m_135815_().matches("metamorphic_\\w+_stone")) continue;
            this.functionTable.put(b2, BlockLootProvider::genMetamorphicStone);
        }
        this.functionTable.put(BotaniaBlocks.bifrost, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.cocoon, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.fakeAir, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.manaFlame, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.cacophonium, b -> BlockLootProvider.genRegular(Blocks.f_50065_));
        this.functionTable.put(BotaniaBlocks.enchantedSoil, b -> BlockLootProvider.genRegular(Blocks.f_50493_));
        this.functionTable.put(BotaniaBlocks.enchanter, b -> BlockLootProvider.genRegular(Blocks.f_50060_));
        this.functionTable.put(BotaniaBlocks.cellBlock, BlockLootProvider::genCellBlock);
        this.functionTable.put(BotaniaBlocks.root, BlockLootProvider::genRoot);
        this.functionTable.put(BotaniaBlocks.solidVines, BlockLootProvider::genSolidVine);
        this.functionTable.put(BotaniaBlocks.tinyPotato, BlockLootProvider::genTinyPotato);
        this.functionTable.put(BotaniaFlowerBlocks.gourmaryllis, b -> BlockLootProvider.genCopyNbt(b, "lastFoods", "lastFoodCount", "streakLength"));
        this.functionTable.put(BotaniaFlowerBlocks.gourmaryllisFloating, b -> BlockLootProvider.genCopyNbt(b, "lastFoods", "lastFoodCount", "streakLength"));
        this.functionTable.put(BotaniaFlowerBlocks.hydroangeas, b -> BlockLootProvider.genCopyNbt(b, "cooldown", "passiveDecayTicks"));
        this.functionTable.put(BotaniaFlowerBlocks.hydroangeasFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown", "passiveDecayTicks"));
        this.functionTable.put(BotaniaFlowerBlocks.munchdew, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(BotaniaFlowerBlocks.munchdewFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(BotaniaFlowerBlocks.rafflowsia, b -> BlockLootProvider.genCopyNbt(b, "lastFlowers", "lastFlowerTimes"));
        this.functionTable.put(BotaniaFlowerBlocks.rafflowsiaFloating, b -> BlockLootProvider.genCopyNbt(b, "lastFlowers", "lastFlowerTimes"));
        this.functionTable.put(BotaniaFlowerBlocks.spectrolus, b -> BlockLootProvider.genCopyNbt(b, "nextColor"));
        this.functionTable.put(BotaniaFlowerBlocks.spectrolusFloating, b -> BlockLootProvider.genCopyNbt(b, "nextColor"));
        this.functionTable.put(BotaniaFlowerBlocks.thermalily, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(BotaniaFlowerBlocks.thermalilyFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (Block b : BuiltInRegistries.f_256975_) {
            Function<Block, LootTable.Builder> func;
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)b);
            if (!"botania".equals(id.m_135827_()) || (func = this.functionTable.getOrDefault(b, BlockLootProvider::genRegular)) == SKIP) continue;
            tables.put(id, func.apply(b));
        }
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        for (Map.Entry e : tables.entrySet()) {
            Path path = this.pathProvider.m_245731_((ResourceLocation)e.getKey());
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)Deserializers.m_78800_().create().toJsonTree((Object)((LootTable.Builder)e.getValue()).m_79165_(LootContextParamSets.f_81421_).m_79167_()), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    protected static LootTable.Builder empty(Block b) {
        return LootTable.m_79147_();
    }

    @Nullable
    protected static LootTable.Builder skip(Block b) {
        return null;
    }

    protected static LootTable.Builder genCopyNbt(Block b, String ... tags) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b);
        CopyNbtFunction.Builder func = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
        for (String tag : tags) {
            func = func.m_80279_(tag, "BlockEntityTag." + tag);
        }
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_79080_(ExplosionCondition.m_81661_()).m_79078_((LootItemFunction.Builder)func);
        return LootTable.m_79147_().m_79161_(pool);
    }

    protected static LootTable.Builder genCellBlock(Block b) {
        ItemPredicate.Builder silkPred = ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)));
        LootPoolEntryContainer.Builder silk = LootItem.m_79579_((ItemLike)b).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)silkPred));
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(silk));
    }

    protected static LootTable.Builder genTinyPotato(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(pool);
    }

    protected static LootTable.Builder genMetamorphicStone(Block b) {
        String cobbleName = BuiltInRegistries.f_256975_.m_7981_((Object)b).m_135815_().replaceAll("_stone", "_cobblestone");
        Block cobble = (Block)BuiltInRegistries.f_256975_.m_6612_(ResourceLocationHelper.prefix(cobbleName)).get();
        return BlockLootProvider.genSilkDrop((ItemLike)b, (ItemLike)cobble);
    }

    protected static LootTable.Builder genSilkDrop(ItemLike silkDrop, ItemLike normalDrop) {
        LootPoolEntryContainer.Builder cobbleDrop = LootItem.m_79579_((ItemLike)normalDrop).m_79080_(ExplosionCondition.m_81661_());
        LootPoolEntryContainer.Builder stoneDrop = LootItem.m_79579_((ItemLike)silkDrop).m_79080_(SILK_TOUCH);
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)stoneDrop.m_7170_(cobbleDrop)));
    }

    protected static LootTable.Builder genSolidVine(Block b) {
        LootPoolSingletonContainer.Builder entry = LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("blocks/vine"));
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry));
    }

    protected static LootTable.Builder genRoot(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)BotaniaItems.livingroot).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry));
    }

    protected static LootTable.Builder genSlab(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry));
    }

    protected static LootTable.Builder genDoubleFlower(Block b) {
        LootPoolSingletonContainer.Builder entry = (LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)b).m_79080_(ExplosionCondition.m_81661_())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)TallFlowerBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)));
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry));
    }

    protected static LootTable.Builder genAltGrass(Block b) {
        LootPoolEntryContainer.Builder silk = LootItem.m_79579_((ItemLike)b).m_79080_(SILK_TOUCH);
        LootPoolEntryContainer.Builder dirt = LootItem.m_79579_((ItemLike)Blocks.f_50493_).m_79080_(ExplosionCondition.m_81661_());
        AlternativesEntry.Builder entry = AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{silk, dirt});
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry);
        return LootTable.m_79147_().m_79161_(pool);
    }

    protected static LootTable.Builder genRegular(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b);
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(pool);
    }

    @NotNull
    public String m_6055_() {
        return "Botania block loot tables";
    }
}

