/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.ITickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;

public class RumbleHandler {
    private static float prevHealth = -1.0f;

    public static void init() {
        TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)RumbleHandler::onClientTick));
    }

    public static void onPlayerUsingItem(Entity entity, ItemStack stack, int duration) {
        if (entity != Minecraft.m_91087_().f_91074_) {
            return;
        }
        if (!((Boolean)Config.CLIENT.client.options.rumble.get()).booleanValue()) {
            return;
        }
        if (Controllable.getInput().getLastUse() <= 0) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller != null) {
            float magnitudeFactor = 0.5f;
            UseAnim action = stack.m_41780_();
            switch (action) {
                case BLOCK: {
                    magnitudeFactor = 0.25f;
                    break;
                }
                case SPEAR: {
                    magnitudeFactor = Mth.m_14036_((float)((float)(stack.m_41779_() - duration) / 20.0f), (float)0.0f, (float)0.25f) / 0.25f;
                    break;
                }
                case BOW: {
                    magnitudeFactor = Mth.m_14036_((float)((float)(stack.m_41779_() - duration) / 20.0f), (float)0.0f, (float)1.0f);
                    break;
                }
                case CROSSBOW: {
                    magnitudeFactor = Mth.m_14036_((float)((float)(stack.m_41779_() - duration) / 20.0f), (float)0.0f, (float)1.5f) / 1.5f;
                    break;
                }
                case EAT: {
                    magnitudeFactor = 0.15f;
                }
            }
            controller.rumble(0.15f * magnitudeFactor, 0.5f * magnitudeFactor, 70);
        }
    }

    private static void onClientTick() {
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null && ((Boolean)Config.CLIENT.client.options.rumble.get()).booleanValue()) {
            if (prevHealth == -1.0f || mc.f_91074_.m_21223_() > prevHealth) {
                prevHealth = mc.f_91074_.m_21223_();
            } else if (prevHealth > mc.f_91074_.m_21223_()) {
                float difference = prevHealth - mc.f_91074_.m_21223_();
                float magnitude = difference / mc.f_91074_.m_21233_();
                controller.rumble(1.0f, 1.0f, (int)(800.0f * magnitude));
                prevHealth = mc.f_91074_.m_21223_();
            }
        } else if (prevHealth != -1.0f) {
            prevHealth = -1.0f;
        }
    }
}

