/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.client.gui.navigation.Navigatable;
import com.mrcrayfish.controllable.client.gui.navigation.SkipItem;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TabSelectionList<E extends ContainerObjectSelectionList.Entry<E>>
extends ContainerObjectSelectionList<E>
implements LayoutElement {
    protected Component headerText;
    protected Component footerText;

    public TabSelectionList(Minecraft mc, int itemHeight) {
        super(mc, 0, 0, 0, 0, itemHeight);
        this.m_93496_(false);
    }

    public TabSelectionList<E> setHeaderText(Component headerText) {
        this.headerText = headerText;
        return this;
    }

    public TabSelectionList<E> setFooterText(Component footerText) {
        this.footerText = footerText;
        return this;
    }

    public int m_5759_() {
        return 290;
    }

    protected int m_5756_() {
        return this.m_5747_() + this.m_5759_() + 4;
    }

    public int addEntry(E entry) {
        return super.m_7085_(entry);
    }

    public void m_252865_(int x) {
        this.f_93393_ = x;
        this.f_93392_ = x + this.f_93388_;
    }

    public void m_253211_(int y) {
        this.f_93390_ = y;
        this.f_93391_ = y + this.f_93389_;
    }

    public int m_252754_() {
        return this.f_93393_;
    }

    public int m_252907_() {
        return this.f_93390_;
    }

    public int m_5711_() {
        return this.f_93388_;
    }

    public int m_93694_() {
        return this.f_93389_;
    }

    public void updateDimensions(ScreenRectangle rectangle) {
        boolean header = this.headerText != null;
        boolean footer = this.footerText != null;
        this.f_93388_ = rectangle.f_263770_();
        this.f_93389_ = rectangle.f_263800_() - 15 + (header ? -10 : 0) + (footer ? -20 : 0);
        this.m_252865_(rectangle.m_274563_());
        this.m_253211_(rectangle.m_274449_() + 15 + (header ? 10 : 0));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.headerText != null) {
            graphics.m_280653_(this.f_93386_.f_91062_, this.headerText, this.f_93393_ + this.f_93388_ / 2, this.f_93390_ - 15, 0xFFFFFF);
        }
        if (this.footerText != null) {
            Font font = this.f_93386_.f_91062_;
            int footerWidth = font.m_92852_((FormattedText)this.footerText);
            ScreenHelper.drawRoundedBox(graphics, this.f_93393_ + (this.f_93388_ - footerWidth) / 2, this.f_93391_ + 4, footerWidth, 14, 0x55000000);
            graphics.m_280653_(font, this.footerText, this.f_93393_ + this.f_93388_ / 2, this.f_93391_ + 7, 0xFFFFFF);
        }
        graphics.m_280024_(this.f_93393_, this.f_93390_, this.f_93392_, this.f_93390_ + 4, -16777216, 0);
        graphics.m_280024_(this.f_93393_, this.f_93391_ - 4, this.f_93392_, this.f_93391_, 0, -16777216);
    }

    public void m_264134_(Consumer<AbstractWidget> consumer) {
    }

    public void m_142291_(NarrationElementOutput output) {
    }

    public static class ButtonItem
    extends BaseItem
    implements Navigatable {
        private final Button button;

        public ButtonItem(Component label, Button.OnPress onPress) {
            super(label);
            this.button = Button.m_253074_((Component)label, (Button.OnPress)onPress).m_253136_();
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.button.m_93674_(width / 2);
            this.button.m_252865_(left + width / 4);
            this.button.m_253211_(top);
            this.button.m_88315_(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.button);
        }

        @Override
        public List<GuiEventListener> elements() {
            return Collections.emptyList();
        }
    }

    public class TitleItem
    extends BaseItem
    implements SkipItem {
        public TitleItem(Component title) {
            super(title);
        }

        public TitleItem(String title) {
            super((Component)Component.m_237113_((String)title).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.YELLOW));
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            Font font = Objects.requireNonNull(((TabSelectionList)TabSelectionList.this).f_93386_).f_91062_;
            int labelWidth = font.m_92852_((FormattedText)this.label) + 2;
            ScreenHelper.drawRoundedBox(graphics, left + width / 2 - labelWidth / 2, top + 2, labelWidth, 14, -2013265920);
            graphics.m_280653_(font, this.label, left + width / 2, top + 5, 0xFFFFFF);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }
    }

    public static abstract class BaseItem
    extends Item<BaseItem> {
        public BaseItem(Component label) {
            super(label);
        }

        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
        }
    }

    public static abstract class Item<T extends ContainerObjectSelectionList.Entry<T>>
    extends ContainerObjectSelectionList.Entry<T> {
        protected Component label;

        public Item(Component label) {
            this.label = label;
        }

        public Component getLabel() {
            return this.label;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, label);
                }
            });
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }
    }
}

