/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input.sdl2;

import com.google.common.io.ByteStreams;
import com.mrcrayfish.controllable.Constants;
import com.mrcrayfish.controllable.client.input.ControllerManager;
import com.mrcrayfish.controllable.client.input.sdl2.SDL2Controller;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import io.github.libsdl4j.api.Sdl;
import io.github.libsdl4j.api.gamecontroller.SdlGamecontroller;
import io.github.libsdl4j.api.joystick.SDL_JoystickID;
import io.github.libsdl4j.api.joystick.SdlJoystick;
import io.github.libsdl4j.api.rwops.SDL_RWops;
import io.github.libsdl4j.api.rwops.SdlRWops;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class SDL2ControllerManager
extends ControllerManager {
    @Override
    public void init() {
        Sdl.SDL_Init((int)8704);
    }

    @Override
    public void dispose() {
        Sdl.SDL_Quit();
    }

    @Override
    public SDL2Controller createController(int deviceIndex, Number jid) {
        return new SDL2Controller(deviceIndex);
    }

    @Override
    protected int getRawControllerCount() {
        int controllerCount = 0;
        int joysticksCount = SdlJoystick.SDL_NumJoysticks();
        for (int deviceIndex = 0; deviceIndex < joysticksCount; ++deviceIndex) {
            if (!SdlGamecontroller.SDL_IsGameController((int)deviceIndex)) continue;
            ++controllerCount;
        }
        return controllerCount;
    }

    @Override
    protected Map<Number, Pair<Integer, String>> createRawControllerMap() {
        HashMap<Number, Pair<Integer, String>> controllers = new HashMap<Number, Pair<Integer, String>>();
        int joysticksCount = SdlJoystick.SDL_NumJoysticks();
        for (int deviceIndex = 0; deviceIndex < joysticksCount; ++deviceIndex) {
            if (!SdlGamecontroller.SDL_IsGameController((int)deviceIndex)) continue;
            SDL_JoystickID jid = SdlJoystick.SDL_JoystickGetDeviceInstanceID((int)deviceIndex);
            String controllerName = SdlGamecontroller.SDL_GameControllerNameForIndex((int)deviceIndex);
            controllers.put((Number)jid, (Pair<Integer, String>)Pair.of((Object)deviceIndex, (Object)controllerName));
        }
        return controllers;
    }

    @Override
    @Nullable
    public SDL2Controller connectToFirstGameController() {
        int joysticksCount = SdlJoystick.SDL_NumJoysticks();
        for (int deviceIndex = 0; deviceIndex < joysticksCount; ++deviceIndex) {
            SDL2Controller controller;
            if (!SdlGamecontroller.SDL_IsGameController((int)deviceIndex) || !this.setActiveController(controller = new SDL2Controller(deviceIndex))) continue;
            return controller;
        }
        return null;
    }

    @Override
    public void updateMappings(InputStream is) throws IOException {
        byte[] bytes = ByteStreams.toByteArray((InputStream)is);
        try (Memory memory = new Memory((long)bytes.length);){
            memory.write(0L, bytes, 0, bytes.length);
            SDL_RWops wops = SdlRWops.SDL_RWFromConstMem((Pointer)memory, (int)((int)memory.size()));
            int count = SdlGamecontroller.SDL_GameControllerAddMappingsFromRW((SDL_RWops)wops, (int)1);
            if (count > 0) {
                Constants.LOG.info("Successfully updated {} gamepad mappings", (Object)count);
                return;
            }
        }
        Constants.LOG.info("No gamepad mappings were updated");
    }
}

