/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.ButtonIcons;
import com.mrcrayfish.controllable.client.Icons;
import com.mrcrayfish.controllable.platform.ClientServices;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ClientHelper {
    public static final ResourceLocation ICON_FONT = new ResourceLocation("controllable", "icons");
    public static final ResourceLocation BUTTON_FONT = new ResourceLocation("controllable", "buttons");

    public static MutableComponent getIconComponent(Icons icon) {
        MutableComponent component = Component.m_237113_((String)String.valueOf((char)(33 + icon.ordinal())));
        component.m_6270_(component.m_7383_().m_131140_(ChatFormatting.WHITE).m_131150_(ICON_FONT));
        return component;
    }

    public static MutableComponent getButtonComponent(int button) {
        MutableComponent component = Component.m_237113_((String)String.valueOf((char)(33 + (((ButtonIcons)Config.CLIENT.client.options.controllerIcons.get()).ordinal() * 23 + button))));
        component.m_6270_(component.m_7383_().m_131140_(ChatFormatting.WHITE).m_131150_(BUTTON_FONT));
        return component;
    }

    public static MutableComponent join(int button, Component label) {
        return Component.m_237119_().m_7220_((Component)ClientHelper.getButtonComponent(button)).m_130946_(" ").m_7220_(label);
    }

    public static MutableComponent join(Icons icon, Component label) {
        return Component.m_237119_().m_7220_((Component)ClientHelper.getIconComponent(icon)).m_130946_(" ").m_7220_(label);
    }

    public static void drawButton(GuiGraphics graphics, int x, int y, int button) {
        int texU = button * 13;
        int texV = ((ButtonIcons)Config.CLIENT.client.options.controllerIcons.get()).ordinal() * 13;
        int size = 13;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280163_(ButtonIcons.TEXTURE, x, y, (float)texU, (float)texV, size, size, 299, ButtonIcons.TEXTURE_HEIGHT);
    }

    public static boolean isPlayingGame() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.m_91403_() != null && mc.m_91403_().m_6198_();
    }

    public static <T extends FormattedText> Tooltip createListTooltip(List<T> lines) {
        List charSequenceList = Language.m_128107_().m_128112_(lines);
        Tooltip blank = Tooltip.m_257550_((Component)CommonComponents.f_237098_);
        ClientServices.CLIENT.pushLinesToTooltip(blank, charSequenceList);
        return blank;
    }

    public static Component getOptionName(OptionInstance<Boolean> option) {
        return ClientServices.CLIENT.getOptionInstanceName(option);
    }

    public static Tooltip getOptionTooltip(OptionInstance<Boolean> option) {
        return ClientServices.CLIENT.getOptionInstanceTooltip(option);
    }

    public static float applyDeadzone(float input, float deadZone) {
        return (float)Mth.m_14205_((double)input) * Math.max(Mth.m_14154_((float)input) - deadZone, 0.0f) / (1.0f - deadZone);
    }

    public static boolean isChatVisible() {
        Minecraft mc = Minecraft.m_91087_();
        List<GuiMessage.Line> messages = ClientServices.CLIENT.getChatTrimmedMessages(mc.f_91065_.m_93076_());
        return mc.f_91080_ == null && messages.stream().anyMatch(chatLine -> mc.f_91065_.m_93079_() - chatLine.f_240350_() < 200);
    }

    public static boolean isSubtitleShowing() {
        Minecraft mc = Minecraft.m_91087_();
        return (Boolean)mc.f_91066_.m_231825_().m_231551_() != false && mc.f_91080_ == null;
    }
}

