/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.platform;

import com.mrcrayfish.controllable.client.ForgeCompatBindingContext;
import com.mrcrayfish.controllable.client.binding.IBindingContext;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.util.ReflectUtil;
import com.mrcrayfish.controllable.integration.JeiSupport;
import com.mrcrayfish.controllable.platform.ClientServices;
import com.mrcrayfish.controllable.platform.services.IClientHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.gui.CreativeTabsScreenPage;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ForgeClientHelper
implements IClientHelper {
    public final Map<IKeyConflictContext, IBindingContext> keyContextMap = new Object2ObjectOpenHashMap();

    @Override
    public float getGuiFarPlane() {
        return ForgeHooksClient.getGuiFarPlane();
    }

    @Override
    public boolean sendScreenInput(Screen screen, int key, int action, int modifiers) {
        boolean[] cancelled = new boolean[]{false};
        Screen.m_96579_(() -> {
            if (action == 0) {
                cancelled[0] = ForgeHooksClient.onScreenKeyReleasedPre((Screen)screen, (int)key, (int)-1, (int)modifiers);
                if (!cancelled[0]) {
                    cancelled[0] = screen.m_7920_(key, -1, modifiers);
                }
                if (!cancelled[0]) {
                    cancelled[0] = ForgeHooksClient.onScreenKeyReleasedPost((Screen)screen, (int)key, (int)-1, (int)modifiers);
                }
            } else if (action == 1) {
                cancelled[0] = ForgeHooksClient.onScreenKeyPressedPre((Screen)screen, (int)key, (int)-1, (int)modifiers);
                if (!cancelled[0]) {
                    cancelled[0] = screen.m_7933_(key, -1, modifiers);
                }
                if (!cancelled[0]) {
                    cancelled[0] = ForgeHooksClient.onScreenKeyPressedPost((Screen)screen, (int)key, (int)-1, (int)modifiers);
                }
            }
        }, (String)"keyPressed event handler", (String)screen.getClass().getCanonicalName());
        return cancelled[0];
    }

    @Override
    public void sendMouseDrag(Screen screen, double dragX, double dragY, double finalMouseX, double finalMouseY, int activeButton) {
        Screen.m_96579_(() -> {
            double finalDragY;
            Minecraft mc = screen.getMinecraft();
            double finalDragX = dragX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_();
            if (ForgeHooksClient.onScreenMouseDragPre((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)activeButton, (double)finalDragX, (double)(finalDragY = dragY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_()))) {
                return;
            }
            if (screen.m_7979_(finalMouseX, finalMouseY, mc.f_91067_.f_91510_, finalDragX, finalDragY)) {
                return;
            }
            ForgeHooksClient.onScreenMouseDragPost((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)activeButton, (double)finalDragX, (double)finalDragY);
        }, (String)"mouseDragged event handler", (String)screen.getClass().getCanonicalName());
    }

    @Override
    public void sendScreenMouseClickPre(Screen screen, double mouseX, double mouseY, int button) {
        Screen.m_96579_(() -> {
            boolean cancelled = ForgeHooksClient.onScreenMouseClickedPre((Screen)screen, (double)mouseX, (double)mouseY, (int)button);
            if (!cancelled) {
                cancelled = screen.m_6375_(mouseX, mouseY, button);
                ForgeHooksClient.onScreenMouseClickedPost((Screen)screen, (double)mouseX, (double)mouseY, (int)button, (boolean)cancelled);
            }
        }, (String)"mouseClicked event handler", (String)screen.getClass().getCanonicalName());
    }

    @Override
    public void sendScreenMouseReleasedPre(Screen screen, double mouseX, double mouseY, int button) {
        Screen.m_96579_(() -> {
            boolean cancelled = ForgeHooksClient.onScreenMouseReleasedPre((Screen)screen, (double)mouseX, (double)mouseY, (int)button);
            if (!cancelled) {
                cancelled = screen.m_6348_(mouseX, mouseY, button);
                ForgeHooksClient.onScreenMouseReleasedPost((Screen)screen, (double)mouseX, (double)mouseY, (int)button, (boolean)cancelled);
            }
        }, (String)"mouseReleased event handler", (String)screen.getClass().getCanonicalName());
    }

    @Override
    public List<GuiMessage.Line> getChatTrimmedMessages(ChatComponent chat) {
        return chat.f_93761_;
    }

    @Override
    public List<NavigationPoint> getJeiNavigationPoints() {
        if (!ModList.get().isLoaded("jei")) {
            return Collections.emptyList();
        }
        return JeiSupport.getNavigationPoints();
    }

    @Override
    public int getMinecraftFramerateLimit() {
        return Minecraft.m_91087_().m_91275_();
    }

    @Override
    public Slot getSlotUnderMouse(AbstractContainerScreen<?> screen) {
        return screen.getSlotUnderMouse();
    }

    @Override
    public int getAbstractListTop(AbstractSelectionList<?> list) {
        return list.getTop();
    }

    @Override
    public int getAbstractListBottom(AbstractSelectionList<?> list) {
        return list.getBottom();
    }

    @Override
    public int getActiveMouseButton() {
        return Minecraft.m_91087_().f_91067_.f_91510_;
    }

    @Override
    public void setActiveMouseButton(int button) {
        Minecraft.m_91087_().f_91067_.f_91510_ = button;
    }

    @Override
    public double getLastMouseEventTime() {
        return Minecraft.m_91087_().f_91067_.f_91519_;
    }

    @Override
    public void setLastMouseEventTime(double time) {
        Minecraft.m_91087_().f_91067_.f_91519_ = time;
    }

    @Override
    public void startUseItem(Minecraft mc) {
        mc.m_91277_();
    }

    @Override
    public int getRightClickDelay(Minecraft mc) {
        return mc.f_91011_;
    }

    @Override
    public void startAttack(Minecraft mc) {
        mc.m_202354_();
    }

    @Override
    public void pickBlock(Minecraft mc) {
        mc.m_91280_();
    }

    @Override
    public List<Renderable> getScreenRenderables(Screen screen) {
        return screen.f_169369_;
    }

    @Override
    public int getScreenTop(AbstractContainerScreen<?> screen) {
        return screen.getGuiTop();
    }

    @Override
    public int getScreenLeft(AbstractContainerScreen<?> screen) {
        return screen.getGuiLeft();
    }

    @Override
    public void gatherCreativeTabNavigationPoints(CreativeModeInventoryScreen screen, List<NavigationPoint> points) {
        CreativeTabsScreenPage page = screen.getCurrentPage();
        page.getVisibleTabs().forEach(tab -> points.add(this.getCreativeTabPoint((AbstractContainerScreen<?>)screen, screen.getCurrentPage(), (CreativeModeTab)tab)));
    }

    @Override
    public boolean canLocalPlayerSwimInFluid(LocalPlayer player) {
        return !player.m_20069_() && !player.isInFluidType((fluidType, height) -> player.canSwimInFluidType(fluidType)) || player.m_5842_() || player.canStartSwimming();
    }

    @Override
    public void scrollCreativeTabs(CreativeModeInventoryScreen screen, int dir) {
        try {
            List pages = (List)ObfuscationReflectionHelper.getPrivateValue(CreativeModeInventoryScreen.class, (Object)screen, (String)"pages");
            if (pages != null) {
                if (dir > 0) {
                    screen.setCurrentPage((CreativeTabsScreenPage)pages.get(Math.min(pages.indexOf(screen.getCurrentPage()) + 1, pages.size() - 1)));
                } else if (dir < 0) {
                    screen.setCurrentPage((CreativeTabsScreenPage)pages.get(Math.max(pages.indexOf(screen.getCurrentPage()) - 1, 0)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public float getCreativeScrollOffset(CreativeModeInventoryScreen screen) {
        return ReflectUtil.getCreativeScrollOffset(screen);
    }

    @Override
    public void setCreativeScrollOffset(CreativeModeInventoryScreen screen, float offset) {
        ReflectUtil.setCreativeScrollOffset(screen, offset);
    }

    @Override
    public int getAbstractListRowBottom(AbstractSelectionList<?> list, int index) {
        return ReflectUtil.getAbstractListRowBottom(list, index);
    }

    @Override
    public int getAbstractListRowTop(AbstractSelectionList<?> list, int index) {
        return ReflectUtil.getAbstractListRowTop(list, index);
    }

    @Override
    public int getListItemHeight(AbstractSelectionList<?> list) {
        return ReflectUtil.getAbstractListItemHeight(list);
    }

    @Override
    public ResourceLocation getImageButtonResource(ImageButton btn) {
        return ReflectUtil.getImageButtonResource(btn);
    }

    @Override
    public void pushLinesToTooltip(Tooltip blank, List<FormattedCharSequence> lines) {
        ReflectUtil.pushLinesToTooltip(blank, lines);
    }

    @Override
    public int getKeyValue(KeyMapping mapping) {
        return mapping.getKey().m_84873_();
    }

    @Override
    public void setKeyPressTime(KeyMapping mapping, int time) {
        ReflectUtil.setKeyPressTime(mapping, time);
    }

    @Override
    public IBindingContext createBindingContext(KeyMapping mapping) {
        return this.keyContextMap.computeIfAbsent(mapping.getKeyConflictContext(), ForgeCompatBindingContext::new);
    }

    @Override
    public void sendKeyInputEvent(int key, int scanCode, int action, int modifiers) {
        ForgeHooksClient.onKeyInput((int)key, (int)0, (int)action, (int)modifiers);
    }

    @Override
    public void clickSlot(AbstractContainerScreen<?> screen, Slot slotIn, int slotId, int mouseButton, ClickType type) {
        ReflectUtil.clickSlot(screen, slotIn, slotId, mouseButton, type);
    }

    @Override
    public void addRenderableToScreen(Screen screen, Renderable renderable) {
        screen.f_169369_.add(renderable);
    }

    @Override
    public Component getOptionInstanceName(OptionInstance<Boolean> option) {
        return option.f_231480_;
    }

    @Override
    public Tooltip getOptionInstanceTooltip(OptionInstance<Boolean> option) {
        return option.f_231474_.m_257630_((Object)true);
    }

    @Override
    public void openChatScreen(String s) {
        Minecraft.m_91087_().m_91326_(s);
    }

    @Override
    public int getStonecutterStartIndex(StonecutterScreen screen) {
        return ReflectUtil.getStonecutterStartIndex(screen);
    }

    @Override
    public int getLoomStartRow(LoomScreen screen) {
        return ReflectUtil.getLoomStartRow(screen);
    }

    private BasicNavigationPoint getCreativeTabPoint(AbstractContainerScreen<?> screen, CreativeTabsScreenPage page, CreativeModeTab tab) {
        int guiLeft = ClientServices.CLIENT.getScreenLeft(screen);
        int guiTop = ClientServices.CLIENT.getScreenTop(screen);
        boolean topRow = page.isTop(tab);
        int column = page.getColumn(tab);
        int width = 28;
        int height = 32;
        int x = guiLeft + width * column;
        int y = guiTop;
        x = tab.m_6563_() ? guiLeft + screen.getXSize() - width * (6 - column) : (column > 0 ? x + column : x);
        y = topRow ? y - width : y + (screen.getYSize() - 4);
        return new BasicNavigationPoint((double)x + (double)width / 2.0, (double)y + (double)height / 2.0);
    }
}

