/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.google.common.base.Predicate;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class CleavingAffix
extends Affix {
    public static final Codec<CleavingAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(CleaveValues.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, CleavingAffix::new));
    protected final Map<LootRarity, CleaveValues> values;
    private static boolean cleaving = false;

    public CleavingAffix(Map<LootRarity, CleaveValues> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat == LootCategory.HEAVY_WEAPON && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{ItemStack.f_41584_.format(100.0f * this.getChance(rarity, level)), this.getTargets(rarity, level)}).m_130940_(ChatFormatting.YELLOW));
    }

    private float getChance(LootRarity rarity, float level) {
        return this.values.get((Object)rarity).chance.get(level);
    }

    private int getTargets(LootRarity rarity, float level) {
        level %= 0.5f;
        return (int)this.values.get((Object)rarity).targets.get(level *= 2.0f);
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        if ((double)Apotheosis.localAtkStrength >= 0.98 && !cleaving && !user.m_9236_().f_46443_) {
            cleaving = true;
            float chance = this.getChance(rarity, level);
            int targets = this.getTargets(rarity, level);
            if (user.m_9236_().f_46441_.m_188501_() < chance && user instanceof Player) {
                Player player = (Player)user;
                List nearby = target.m_9236_().m_6249_(target, new AABB(target.m_20183_()).m_82400_(6.0), CleavingAffix.cleavePredicate((Entity)user, target));
                for (Entity e : nearby) {
                    if (targets <= 0) continue;
                    user.f_20922_ = 300;
                    player.m_5706_(e);
                    --targets;
                }
            }
            cleaving = false;
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static Predicate<Entity> cleavePredicate(Entity user, Entity target) {
        return e -> {
            LivingEntity le;
            if (e instanceof Animal && !(target instanceof Animal) || e instanceof AbstractVillager && !(target instanceof AbstractVillager)) {
                return false;
            }
            if (!AdventureConfig.cleaveHitsPlayers && e instanceof Player) {
                return false;
            }
            if (target instanceof Enemy && !(e instanceof Enemy)) {
                return false;
            }
            return e != user && e instanceof LivingEntity && (le = (LivingEntity)e).m_6084_();
        };
    }

    record CleaveValues(StepFunction chance, StepFunction targets) {
        public static final Codec<CleaveValues> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.fieldOf("chance").forGetter(c -> c.chance), (App)StepFunction.CODEC.fieldOf("targets").forGetter(c -> c.targets)).apply((Applicative)inst, CleaveValues::new));
    }
}

