/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class Gem
implements CodecProvider<Gem>,
WeightedDynamicRegistry.ILuckyWeighted,
WeightedDynamicRegistry.IDimensional,
RarityClamp,
GameStagesCompat.IStaged {
    public static final Codec<Gem> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedDynamicRegistry.ILuckyWeighted::getWeight), (App)PlaceboCodecs.nullableField((Codec)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE), (String)"quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedDynamicRegistry.ILuckyWeighted::getQuality), (App)PlaceboCodecs.nullableField((Codec)PlaceboCodecs.setOf((Codec)ResourceLocation.f_135803_), (String)"dimensions", Collections.emptySet()).forGetter(WeightedDynamicRegistry.IDimensional::getDimensions), (App)PlaceboCodecs.nullableField(LootRarity.CODEC, (String)"min_rarity").forGetter(g -> Optional.of(g.getMinRarity())), (App)PlaceboCodecs.nullableField(LootRarity.CODEC, (String)"max_rarity").forGetter(g -> Optional.of(g.getMaxRarity())), (App)GemBonus.CODEC.listOf().fieldOf("bonuses").forGetter(Gem::getBonuses), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"unique", (Object)false).forGetter(Gem::isUnique), (App)PlaceboCodecs.nullableField((Codec)PlaceboCodecs.setOf((Codec)Codec.STRING), (String)"stages").forGetter(gem -> Optional.ofNullable(gem.getStages()))).apply((Applicative)inst, Gem::new));
    protected final int weight;
    protected final float quality;
    protected final Set<ResourceLocation> dimensions;
    protected final List<GemBonus> bonuses;
    protected final boolean unique;
    @Nullable
    protected final Set<String> stages;
    protected final transient Map<LootCategory, GemBonus> bonusMap;
    protected final transient int uuidsNeeded;
    protected final transient LootRarity minRarity;
    protected final transient LootRarity maxRarity;

    public Gem(int weight, float quality, Set<ResourceLocation> dimensions, Optional<LootRarity> minRarity, Optional<LootRarity> maxRarity, List<GemBonus> bonuses, boolean unique, Optional<Set<String>> stages) {
        this.weight = weight;
        this.quality = quality;
        this.dimensions = dimensions;
        this.bonuses = bonuses;
        this.unique = unique;
        this.stages = stages.orElse(null);
        Preconditions.checkArgument((!bonuses.isEmpty() ? 1 : 0) != 0, (Object)"No bonuses were provided.");
        this.bonusMap = bonuses.stream().mapMulti((gemData, mapper) -> {
            for (LootCategory c : gemData.getGemClass().types()) {
                mapper.accept(Pair.of((Object)c, (Object)gemData));
            }
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        this.uuidsNeeded = this.bonuses.stream().mapToInt(GemBonus::getNumberOfUUIDs).max().orElse(0);
        this.minRarity = minRarity.isPresent() ? minRarity.get() : RarityRegistry.INSTANCE.getValues().stream().filter(bonuses.get(0)::supports).min(LootRarity::compareTo).get();
        this.maxRarity = maxRarity.isPresent() ? maxRarity.get() : RarityRegistry.INSTANCE.getValues().stream().filter(bonuses.get(0)::supports).max(LootRarity::compareTo).get();
        Preconditions.checkArgument((this.minRarity.ordinal() <= this.maxRarity.ordinal() ? 1 : 0) != 0, (Object)"The min rarity must be <= the max rarity.");
    }

    public int getNumberOfUUIDs() {
        return this.uuidsNeeded;
    }

    public void addInformation(ItemStack gem, LootRarity rarity, Consumer<Component> list) {
        if (this.isUnique()) {
            list.accept((Component)Component.m_237115_((String)"text.apotheosis.unique").m_130948_(Style.f_131099_.m_178520_(13056274)));
        }
        list.accept(CommonComponents.f_237098_);
        Style style = Style.f_131099_.m_178520_(720650);
        list.accept((Component)Component.m_237115_((String)"text.apotheosis.socketable_into").m_130948_(style));
        Gem.addTypeInfo(list, this.bonusMap.keySet().toArray());
        list.accept(CommonComponents.f_237098_);
        if (this.bonuses.size() == 1) {
            list.accept((Component)Component.m_237115_((String)"item.modifiers.socket").m_130940_(ChatFormatting.GOLD));
            list.accept(this.bonuses.get(0).getSocketBonusTooltip(gem, rarity));
        } else {
            list.accept((Component)Component.m_237115_((String)"item.modifiers.socket_in").m_130940_(ChatFormatting.GOLD));
            for (GemBonus bonus : this.bonuses) {
                if (!bonus.supports(rarity)) continue;
                Component modifComp = bonus.getSocketBonusTooltip(gem, rarity);
                MutableComponent sum = Component.m_237110_((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{Component.m_237110_((String)"%s: %s", (Object[])new Object[]{Component.m_237115_((String)("gem_class." + bonus.getGemClass().key())), modifComp})}).m_130940_(ChatFormatting.GOLD);
                list.accept((Component)sum);
            }
        }
    }

    public boolean canApplyTo(ItemStack socketed, ItemStack gem, LootRarity rarity) {
        List<Gem> gems;
        if (this.isUnique() && (gems = SocketHelper.getGemInstances(socketed).map(GemInstance::gem).map(DynamicHolder::get).toList()).contains(this)) {
            return false;
        }
        return this.isValidIn(socketed, gem, rarity);
    }

    public boolean isValidIn(ItemStack socketed, ItemStack gem, LootRarity rarity) {
        LootCategory cat = LootCategory.forItem(socketed);
        return !cat.isNone() && this.bonusMap.containsKey(cat) && this.bonusMap.get(cat).supports(rarity);
    }

    public Optional<GemBonus> getBonus(LootCategory cat) {
        return Optional.ofNullable(this.bonusMap.get(cat));
    }

    public String toString() {
        return String.format("Gem: %s", this.getId());
    }

    public static String fmt(float f) {
        return Affix.fmt(f);
    }

    public float getQuality() {
        return this.quality;
    }

    public int getWeight() {
        return this.weight;
    }

    public Set<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    @Override
    public LootRarity getMaxRarity() {
        return this.maxRarity;
    }

    @Override
    public LootRarity getMinRarity() {
        return this.minRarity;
    }

    public List<GemBonus> getBonuses() {
        return this.bonuses;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Gem validate(ResourceLocation key) {
        Preconditions.checkNotNull(this.dimensions);
        Preconditions.checkArgument((this.maxRarity.ordinal() >= this.minRarity.ordinal() ? 1 : 0) != 0);
        RarityRegistry.INSTANCE.getValues().stream().filter(r -> r.isAtLeast(this.minRarity) && r.isAtMost(this.maxRarity)).forEach(r -> Preconditions.checkArgument((boolean)this.bonuses.stream().allMatch(b -> b.supports((LootRarity)r))));
        return this;
    }

    @Override
    public Set<String> getStages() {
        return this.stages;
    }

    public Codec<? extends Gem> getCodec() {
        return CODEC;
    }

    public static void addTypeInfo(Consumer<Component> list, Object ... types) {
        Arrays.sort(types, (c1, c2) -> ((LootCategory)c1).getName().compareTo(((LootCategory)c2).getName()));
        Style style = Style.f_131099_.m_178520_(720650);
        if (types.length != LootCategory.BY_ID.size() - 1) {
            int rem;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < types.length; i += rem) {
                rem = Math.min(3, types.length - i);
                Object[] args = new Object[rem];
                for (int r = 0; r < rem; ++r) {
                    sb.append("%s, ");
                    args[r] = Component.m_237115_((String)((LootCategory)types[i + r]).getDescIdPlural());
                }
                list.accept((Component)Component.m_237110_((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{Component.m_237110_((String)sb.substring(0, sb.length() - 2), (Object[])args)}).m_130948_(style));
                sb.setLength(0);
            }
        } else {
            list.accept((Component)Component.m_237110_((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{Component.m_237115_((String)"text.apotheosis.anything")}).m_130948_(style));
        }
    }

    public final ResourceLocation getId() {
        return GemRegistry.INSTANCE.getKey(this);
    }
}

