/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class DurabilityBonus
extends GemBonus {
    public static Codec<DurabilityBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(DurabilityBonus.gemClass(), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, DurabilityBonus::new));
    protected final Map<LootRarity, StepFunction> values;

    public DurabilityBonus(GemClass gemClass, Map<LootRarity, StepFunction> values) {
        super(Apotheosis.loc("durability"), gemClass);
        this.values = values;
    }

    @Override
    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        float level = this.values.get(rarity).get(0.0f);
        return Component.m_237110_((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(100.0f * level)}).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public float getDurabilityBonusPercentage(ItemStack gem, LootRarity rarity, ServerPlayer user) {
        return this.values.get(rarity).min();
    }

    @Override
    public GemBonus validate() {
        Preconditions.checkNotNull(this.values, (Object)"Invalid AttributeBonus with null values");
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

