/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class AllStatsBonus
extends GemBonus {
    public static Codec<AllStatsBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(AllStatsBonus.gemClass(), (App)PlaceboCodecs.enumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.operation), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)BuiltInRegistries.f_256951_.m_194605_().listOf().fieldOf("attributes").forGetter(a -> a.attributes)).apply((Applicative)inst, AllStatsBonus::new));
    protected final AttributeModifier.Operation operation;
    protected final Map<LootRarity, StepFunction> values;
    protected final List<Attribute> attributes;

    public AllStatsBonus(GemClass gemClass, AttributeModifier.Operation op, Map<LootRarity, StepFunction> values, List<Attribute> attributes) {
        super(Apotheosis.loc("all_stats"), gemClass);
        this.operation = op;
        this.values = values;
        this.attributes = attributes;
    }

    @Override
    public void addModifiers(ItemStack gem, LootRarity rarity, BiConsumer<Attribute, AttributeModifier> map) {
        UUID id = GemItem.getUUIDs(gem).get(0);
        for (Attribute attr : this.attributes) {
            AttributeModifier modif = new AttributeModifier(id, "apoth.gem_modifier.all_stats_buff", (double)this.values.get(rarity).min(), this.operation);
            map.accept(attr, modif);
        }
    }

    @Override
    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        StepFunction value = this.values.get(rarity);
        return Component.m_237110_((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(value.get(0.0f) * 100.0f)}).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public AllStatsBonus validate() {
        Preconditions.checkNotNull((Object)this.operation, (Object)"Invalid AllStatsBonus with null operation");
        Preconditions.checkNotNull(this.values, (Object)"Invalid AllStatsBonus with null values");
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 1;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

