/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.IngredientCodec;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import dev.shadowsoffire.placebo.util.StepFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class DropTransformBonus
extends GemBonus {
    public static Codec<DropTransformBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(DropTransformBonus.gemClass(), (App)TagKey.m_203877_((ResourceKey)Registries.f_256747_).fieldOf("blocks").forGetter(a -> a.tag), (App)IngredientCodec.INSTANCE.fieldOf("inputs").forGetter(a -> a.inputs), (App)ItemAdapter.CODEC.fieldOf("output").forGetter(a -> a.output), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)Codec.STRING.fieldOf("desc").forGetter(a -> a.descKey)).apply((Applicative)inst, DropTransformBonus::new));
    protected final TagKey<Block> tag;
    protected final Ingredient inputs;
    protected final ItemStack output;
    protected final Map<LootRarity, StepFunction> values;
    protected final String descKey;
    protected final transient List<Block> blocks;

    public DropTransformBonus(GemClass gemClass, TagKey<Block> tag, Ingredient inputs, ItemStack output, Map<LootRarity, StepFunction> values, String descKey) {
        super(Apotheosis.loc("drop_transform"), gemClass);
        this.tag = tag;
        this.inputs = inputs;
        this.output = output;
        this.values = values;
        this.descKey = descKey;
        this.blocks = EffectiveSide.get().isServer() ? GemRegistry.INSTANCE._getContext().getTag(tag).stream().map(Holder::get).toList() : Collections.emptyList();
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        float chance = this.values.get(rarity).min();
        return Component.m_237110_((String)this.descKey, (Object[])new Object[]{Affix.fmt(chance * 100.0f)}).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public void modifyLoot(ItemStack gem, LootRarity rarity, ObjectArrayList<ItemStack> loot, LootContext ctx) {
        if (ctx.m_78936_(LootContextParams.f_81461_)) {
            Block block = ((BlockState)ctx.m_165124_(LootContextParams.f_81461_)).m_60734_();
            if (!this.blocks.isEmpty() && !this.blocks.contains(block)) {
                return;
            }
            if (ctx.m_230907_().m_188501_() <= this.values.get(rarity).min()) {
                for (int i = 0; i < loot.size(); ++i) {
                    ItemStack stack = (ItemStack)loot.get(i);
                    if (!this.inputs.test(stack)) continue;
                    ItemStack outCopy = this.output.m_41777_();
                    outCopy.m_41764_(stack.m_41613_());
                    loot.set(i, (Object)outCopy);
                }
            }
        }
    }

    @Override
    public DropTransformBonus validate() {
        Preconditions.checkNotNull(this.values);
        this.values.forEach((k, v) -> {
            Preconditions.checkNotNull((Object)k);
            Preconditions.checkNotNull((Object)v);
        });
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }
}

