/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootRarity
implements CodecProvider<LootRarity>,
WeightedDynamicRegistry.ILuckyWeighted,
Comparable<LootRarity> {
    public static final Codec<LootRarity> LOAD_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TextColor.f_237295_.fieldOf("color").forGetter(LootRarity::getColor), (App)ForgeRegistries.ITEMS.getCodec().fieldOf("material").forGetter(LootRarity::getMaterial), (App)Codec.INT.fieldOf("ordinal").forGetter(LootRarity::ordinal), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedDynamicRegistry.ILuckyWeighted::getWeight), (App)PlaceboCodecs.nullableField((Codec)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE), (String)"quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedDynamicRegistry.ILuckyWeighted::getQuality), (App)new ListCodec(LootRule.CODEC).fieldOf("rules").forGetter(LootRarity::getRules)).apply((Applicative)inst, LootRarity::new));
    @Deprecated
    public static final Codec<DynamicHolder<LootRarity>> HOLDER_CODEC = ExtraCodecs.m_184415_(() -> Codec.STRING.xmap(RarityRegistry::convertId, ResourceLocation::toString).xmap(arg_0 -> ((RarityRegistry)RarityRegistry.INSTANCE).holder(arg_0), DynamicHolder::getId));
    public static final Codec<LootRarity> CODEC = ExtraCodecs.m_184415_(() -> HOLDER_CODEC.xmap(DynamicHolder::get, arg_0 -> ((RarityRegistry)RarityRegistry.INSTANCE).holder(arg_0)));
    private final Item material;
    private final TextColor color;
    private final int ordinal;
    private final int weight;
    private final float quality;
    private final List<LootRule> rules;

    private LootRarity(TextColor color, Item material, int ordinal, int weight, float quality, List<LootRule> rules) {
        this.color = color;
        this.material = material;
        this.ordinal = ordinal;
        this.weight = weight;
        this.quality = quality;
        this.rules = rules;
    }

    public Item getMaterial() {
        return this.material;
    }

    public TextColor getColor() {
        return this.color;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public List<LootRule> getRules() {
        return this.rules;
    }

    public LootRarity next() {
        return (LootRarity)RarityRegistry.next((DynamicHolder<LootRarity>)RarityRegistry.INSTANCE.holder(this)).get();
    }

    public LootRarity prev() {
        return (LootRarity)RarityRegistry.prev((DynamicHolder<LootRarity>)RarityRegistry.INSTANCE.holder(this)).get();
    }

    public boolean isAtMost(LootRarity other) {
        return this.ordinal() <= other.ordinal();
    }

    public boolean isAtLeast(LootRarity other) {
        return this.ordinal() >= other.ordinal();
    }

    public static LootRarity min(LootRarity a, @Nullable LootRarity b) {
        if (b == null) {
            return a;
        }
        return a.ordinal <= b.ordinal ? a : b;
    }

    public static LootRarity max(LootRarity a, @Nullable LootRarity b) {
        if (b == null) {
            return a;
        }
        return a.ordinal >= b.ordinal ? a : b;
    }

    public LootRarity clamp(@Nullable LootRarity lowerBound, @Nullable LootRarity upperBound) {
        return LootRarity.max(LootRarity.min(this, upperBound), lowerBound);
    }

    public Component toComponent() {
        return Component.m_237115_((String)("rarity." + RarityRegistry.INSTANCE.getKey(this))).m_130948_(Style.f_131099_.m_131148_(this.color));
    }

    public String toString() {
        return "LootRarity{" + RarityRegistry.INSTANCE.getKey(this) + "}";
    }

    @Override
    public int compareTo(LootRarity o) {
        return Integer.compare(this.ordinal, o.ordinal);
    }

    public Codec<? extends LootRarity> getCodec() {
        return LOAD_CODEC;
    }

    public static LootRarity random(RandomSource rand, float luck) {
        return (LootRarity)RarityRegistry.INSTANCE.getRandomItem(rand, luck);
    }

    public static LootRarity random(RandomSource rand, float luck, @Nullable RarityClamp clamp) {
        LootRarity rarity = LootRarity.random(rand, luck);
        return clamp == null ? rarity : clamp.clamp(rarity);
    }

    public static <T> Codec<Map<LootRarity, T>> mapCodec(Codec<T> codec) {
        return Codec.unboundedMap(CODEC, codec);
    }

    public record LootRule(AffixType type, float chance, @Nullable LootRule backup) {
        public static final Codec<LootRule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.enumCodec(AffixType.class).fieldOf("type").forGetter(LootRule::type), (App)Codec.FLOAT.fieldOf("chance").forGetter(LootRule::chance), (App)PlaceboCodecs.nullableField((Codec)ExtraCodecs.m_184415_(() -> CODEC), (String)"backup").forGetter(rule -> Optional.ofNullable(rule.backup()))).apply((Applicative)inst, LootRule::new));
        private static Random jRand = new Random();

        public LootRule(AffixType type, float chance) {
            this(type, chance, Optional.empty());
        }

        public LootRule(AffixType type, float chance, Optional<LootRule> backup) {
            this(type, chance, (LootRule)backup.orElse(null));
        }

        public void execute(ItemStack stack, LootRarity rarity, Set<DynamicHolder<Affix>> currentAffixes, MutableInt sockets, RandomSource rand) {
            if (this.type == AffixType.DURABILITY) {
                return;
            }
            if (rand.m_188501_() <= this.chance) {
                if (this.type == AffixType.SOCKET) {
                    sockets.add(1);
                    return;
                }
                List available = AffixHelper.byType(this.type).stream().filter(a -> ((Affix)a.get()).canApplyTo(stack, LootCategory.forItem(stack), rarity) && !currentAffixes.contains(a)).collect(Collectors.toList());
                if (available.size() == 0) {
                    if (this.backup != null) {
                        this.backup.execute(stack, rarity, currentAffixes, sockets, rand);
                    } else {
                        AdventureModule.LOGGER.error("Failed to execute LootRule {}/{}/{}/{}!", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), (Object)RarityRegistry.INSTANCE.getKey(rarity), (Object)this.type, (Object)Float.valueOf(this.chance));
                    }
                    return;
                }
                jRand.setSeed(rand.m_188505_());
                Collections.shuffle(available, jRand);
                currentAffixes.add((DynamicHolder<Affix>)((DynamicHolder)available.get(0)));
            }
        }
    }
}

