/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.potion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.placebo.recipe.RecipeHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionCharmRecipe
extends ShapedRecipe {
    protected final IntList potionSlots = new IntArrayList();
    protected final Ingredient potion = PotionCharmRecipe.makePotionIngredient();

    public PotionCharmRecipe(List<Object> ingredients, int width, int height) {
        super(new ResourceLocation("apotheosis", "potion_charm"), "", CraftingBookCategory.MISC, width, height, PotionCharmRecipe.makeIngredients(ingredients), new ItemStack((ItemLike)Apoth.Items.POTION_CHARM.get()));
        for (int i = 0; i < ingredients.size(); ++i) {
            if (!"potion".equals(ingredients.get(i))) continue;
            this.potionSlots.add(i);
        }
    }

    private static Ingredient makePotionIngredient() {
        ArrayList<ItemStack> potionStacks = new ArrayList<ItemStack>();
        for (Potion p : ForgeRegistries.POTIONS) {
            if (p.m_43488_().size() != 1 || ((MobEffectInstance)p.m_43488_().get(0)).m_19544_().m_8093_()) continue;
            ItemStack potion = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)potion, (Potion)p);
            potionStacks.add(potion);
        }
        return Ingredient.m_43927_((ItemStack[])potionStacks.toArray(new ItemStack[0]));
    }

    private static NonNullList<Ingredient> makeIngredients(List<Object> ingredients) {
        ArrayList<Object> realIngredients = new ArrayList<Object>();
        Ingredient potion = PotionCharmRecipe.makePotionIngredient();
        for (Object o : ingredients) {
            if ("potion".equals(o)) {
                realIngredients.add(potion);
                continue;
            }
            realIngredients.add(o);
        }
        return RecipeHelper.createInput((String)"apotheosis", (boolean)true, (Object[])realIngredients.toArray());
    }

    public Ingredient getPotionIngredient() {
        return this.potion;
    }

    public IntList getPotionSlots() {
        return this.potionSlots;
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess regs) {
        ItemStack out = super.m_5874_(inv, regs);
        PotionUtils.m_43549_((ItemStack)out, (Potion)PotionUtils.m_43579_((ItemStack)inv.m_8020_(4)));
        return out;
    }

    public boolean m_5818_(CraftingContainer inv, Level world) {
        List potions;
        if (super.m_5818_(inv, world) && (potions = this.potionSlots.intStream().mapToObj(s -> inv.m_8020_(s)).map(PotionUtils::m_43579_).collect(Collectors.toList())).size() > 0 && potions.stream().allMatch(p -> p != null && p.m_43488_().size() == 1 && !((MobEffectInstance)p.m_43488_().get(0)).m_19544_().m_8093_())) {
            return potions.stream().distinct().count() == 1L;
        }
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<PotionCharmRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public PotionCharmRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray inputs = json.get("recipe").getAsJsonArray();
            int width = 0;
            int height = inputs.size();
            ArrayList<Object> ingredients = new ArrayList<Object>();
            for (JsonElement e : inputs) {
                JsonArray arr = e.getAsJsonArray();
                width = arr.size();
                for (JsonElement input : arr) {
                    if (input.isJsonPrimitive() && "potion".equals(input.getAsString())) {
                        ingredients.add("potion");
                        continue;
                    }
                    ingredients.add(CraftingHelper.getIngredient((JsonElement)input, (boolean)false));
                }
            }
            return new PotionCharmRecipe(ingredients, width, height);
        }

        public PotionCharmRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            byte width = buffer.readByte();
            byte height = buffer.readByte();
            int potions = buffer.readByte();
            IntArrayList potionSlots = new IntArrayList();
            for (int i = 0; i < potions; ++i) {
                potionSlots.add((int)buffer.readByte());
            }
            ArrayList<Object> inputs = new ArrayList<Object>(width * height);
            for (int i = 0; i < width * height; ++i) {
                if (!potionSlots.contains(i)) {
                    inputs.add(i, Ingredient.m_43940_((FriendlyByteBuf)buffer));
                    continue;
                }
                inputs.add("potion");
            }
            return new PotionCharmRecipe(inputs, width, height);
        }

        public void toNetwork(FriendlyByteBuf buffer, PotionCharmRecipe recipe) {
            int i;
            buffer.writeByte(recipe.getRecipeWidth());
            buffer.writeByte(recipe.getRecipeHeight());
            buffer.writeByte(recipe.potionSlots.size());
            IntListIterator intListIterator = recipe.potionSlots.iterator();
            while (intListIterator.hasNext()) {
                i = (Integer)intListIterator.next();
                buffer.writeByte(i);
            }
            NonNullList inputs = recipe.m_7527_();
            for (i = 0; i < inputs.size(); ++i) {
                if (recipe.potionSlots.contains(i)) continue;
                ((Ingredient)inputs.get(i)).m_43923_(buffer);
            }
        }
    }
}

